#pragma once
#include "base.h"


class TCompositeAction : public INotifierActionBase {
    using TBase = INotifierActionBase;
public:
    virtual bool DeserializeFromJson(const NJson::TJsonValue& json) override;
    virtual NJson::TJsonValue SerializeToJson() const override;
    virtual NDrive::TScheme GetScheme(const IServerBase& server) const override;
    virtual bool DoFinish(const TSet<TString>& objectIds, NAlerts::TFetcherContext& context) override;
    virtual TString GetActionType() const override;
    virtual void SetEntityType(NAlerts::EAlertEntityType entityType) override;
private:
    void DoApply(const TString& /*objectId*/, const NAlerts::TFetchedMap& /*parameters*/, NAlerts::TFetcherContext& context) override;

public:
    static inline const TString TypeName{"composite"};

private:
    TVector<INotifierActionBase::TPtr> Actions;
    static inline const TFactory::TRegistrator<TCompositeAction> Registrator{TypeName};
};
