#include "node.h"

INotifierActionBase::TFactory::TRegistrator<TChainNodeAction> TChainNodeAction::Registrator("chain_node");

bool TChainNodeAction::DeserializeFromJson(const NJson::TJsonValue& json) {
    JREAD_FROM_STRING_OPT(json, "node_type", NodeType);
    for (auto&& data : json["additional_tags"].GetArray()) {
        if (!data.IsMap() && !data.IsString()) {
            return false;
        }
        AdditionalTags.push_back(data.GetStringRobust());
    }
    if (!ChainContext.DeserializeFromJson(json)) {
        return false;
    }
    return INotifierActionBase::DeserializeFromJson(json);
}

NJson::TJsonValue TChainNodeAction::SerializeToJson() const {
    NJson::TJsonValue result = INotifierActionBase::SerializeToJson();
    ChainContext.SerializeToJson(result);
    result["node_type"] = ToString(NodeType);
    for (auto&& tag : AdditionalTags) {
        result["additional_tags"].AppendValue(tag);
    }
    return result;
}

NDrive::TScheme TChainNodeAction::GetScheme(const IServerBase& server) const {
    NDrive::TScheme scheme = INotifierActionBase::GetScheme(server);
    ITagsMeta::TTagDescriptionsByName tags = server.GetAsSafe<NDrive::IServer>().GetDriveAPI()->GetTagsManager().GetTagsMeta().GetRegisteredTags(NEntityTagsManager::EEntityType::User, { TUserAlertTag::TypeName, TCarAlertTag::TypeName });
    NAlerts::TChainContext::GetScheme(scheme, MakeVector(NContainer::Keys(tags)));
    scheme.Add<TFSVariants>("node_type", "Тип узла (контрольный - создает и удаляет теги/второй только для обновления состояний)").InitVariants<ENodeType>().SetDefault(::ToString(ENodeType::Update));
    scheme.Add<TFSArray>("additional_tags", "Дополнительные теги (навешиваются при срабатывании)").SetElement<TFSJson>();
    return scheme;
}

TString TChainNodeAction::GetActionType() const {
    return "chain_node";
}
