#pragma once
#include "base.h"

class TUserRoleAction : public INotifierActionBase {
public:
    virtual bool DeserializeFromJson(const NJson::TJsonValue& json) override;
    virtual NJson::TJsonValue SerializeToJson() const override;
    virtual NDrive::TScheme GetScheme(const IServerBase& server) const override;
    virtual bool DoFinish(const TSet<TString>& objectIds, NAlerts::TFetcherContext& context) override;
    virtual TString GetActionType() const override;

private:
    TSet<TString> RoleNames;
    bool AutoRevert = true;
    bool Reverse = false;
    bool OnlyActivate = false;
    bool OnlyAdd = false;
    static TFactory::TRegistrator<TUserRoleAction> Registrator;
};

class TWalletAction : public INotifierActionBase {
public:
    virtual bool DeserializeFromJson(const NJson::TJsonValue& json) override;
    virtual NJson::TJsonValue SerializeToJson() const override;
    virtual NDrive::TScheme GetScheme(const IServerBase& server) const override;
    virtual bool DoFinish(const TSet<TString>& objectIds, NAlerts::TFetcherContext& context) override;
    virtual TString GetActionType() const override;

private:
    TString AccountName;
    static TFactory::TRegistrator<TWalletAction> Registrator;
};


class TYtDumpAction : public INotifierActionBase {
public:
    virtual bool DeserializeFromJson(const NJson::TJsonValue& json) override;
    virtual NJson::TJsonValue SerializeToJson() const override;
    virtual NDrive::TScheme GetScheme(const IServerBase& server) const override;
    virtual bool DoFinish(const TSet<TString>& objectIds, NAlerts::TFetcherContext& context) override;
    virtual TString GetActionType() const override;

private:
    TString TagName;
    TString YTDir;
    static TFactory::TRegistrator<TYtDumpAction> Registrator;
};


class TEvolveSessionAction : public INotifierActionBase {
public:
    virtual bool DeserializeFromJson(const NJson::TJsonValue& json) override;
    virtual NJson::TJsonValue SerializeToJson() const override;
    virtual NDrive::TScheme GetScheme(const IServerBase& server) const override;
    virtual bool DoFinish(const TSet<TString>& objectIds, NAlerts::TFetcherContext& context) override;
    virtual TString GetActionType() const override;

private:
    TString StateFrom;
    TString StateTo;
 //   bool DryRun = true;
    static TFactory::TRegistrator<TEvolveSessionAction> Registrator;
};
