#pragma once

#include "base.h"

#include <drive/backend/tags/tag_modification.h>

class TTagActionImpl : public INotifierActionBase {
public:
    class TModifications : public ITagsModificationContextImplBase {
        using TBase = ITagsModificationContextImplBase;
        const NAlerts::TFetcherContext& Context;
    public:
        TModifications(const NAlerts::TFetcherContext& context)
            : TBase(*context.GetServer())
            , Context(context)
        {}

        virtual TAbstractTagsModification* GetModification(const TString& objectId, bool /*checkObject = true*/) override {
            auto it = MutableTagModifications().find(objectId);
            if (it == MutableTagModifications().end()) {
                TAbstractTagsModification modNew(objectId, "");
                return &MutableTagModifications().emplace(objectId, std::move(modNew)).first->second;
            } else {
                return &it->second;
            }
        }

        virtual const TString& GetProcessName() const override {
            return Context.GetCurrentState();
        }

        virtual const TString& GetRobotUserId() const override {
            return Context.GetRobotUserId();
        }
    };

public:
    virtual bool DoFinish(const TSet<TString>& objectIds, NAlerts::TFetcherContext& context) override;

protected:
    virtual bool DeserializeFromJson(const NJson::TJsonValue& json) override;
    virtual NJson::TJsonValue SerializeToJson() const override;
    virtual NDrive::TScheme GetScheme(const IServerBase& server) const override;
    virtual TMaybe<NEntityTagsManager::EEntityType> GetTagEntityType() const;
    virtual bool HandleObject(const TString objectId, TMap<TString, TVector<TDBTag>>& tagsByObject, NAlerts::TFetcherContext& context);
    virtual bool InitAction(const NAlerts::TFetcherContext& context);
    virtual bool CommitAction(NAlerts::TFetcherContext& context);

private:
    TString AlertTagData;
    TString TagName;
    TString Filter;
    TVector<TString> AdditionalTags;
    bool AutoRemove = true;
    ui32 MaxTags = 100;
    EObjectHistoryAction TagAction = EObjectHistoryAction::Add;
    THolder<TModifications> ModificationsPtr;
};

class TUserTagAction : public TTagActionImpl {
public:
    virtual TString GetActionType() const override {
        return TypeName;
    }

public:
    static inline const TString TypeName{"user_tags"};

private:
    static inline const TFactory::TRegistrator<TUserTagAction> Registrator{TypeName};
};

class TCarTagAction : public TTagActionImpl {
public:
    virtual TString GetActionType() const override {
        return TypeName;
    }

public:
    static inline const TString TypeName{"car_tags"};

private:
    static inline const TFactory::TRegistrator<TCarTagAction> Registrator{TypeName};
};

class TTraceTagAction : public TTagActionImpl {
public:
    virtual TString GetActionType() const override {
        return TypeName;
    }

protected:
    virtual bool DeserializeFromJson(const NJson::TJsonValue& json) override;
    virtual NJson::TJsonValue SerializeToJson() const override;
    virtual NDrive::TScheme GetScheme(const IServerBase& server) const override;
    virtual TMaybe<NEntityTagsManager::EEntityType> GetTagEntityType() const override;
    virtual bool HandleObject(const TString objectId, TMap<TString, TVector<TDBTag>>& tagsByObject, NAlerts::TFetcherContext& context) override;
    virtual bool InitAction(const NAlerts::TFetcherContext& context) override;
    virtual bool CommitAction(NAlerts::TFetcherContext& context) override;

public:
    static inline const TString TypeName{"trace_tags"};

private:
    TVector<TString> AdditionalUserTags;
    THolder<TModifications> UserTagModificationsPtr;

    static inline const TFactory::TRegistrator<TTraceTagAction> Registrator{TypeName};
};
