#include "tags_histogram.h"

INotifierActionBase::TFactory::TRegistrator<TTagsHistorgamAction> TTagsHistorgamAction::Registrator("tags_histogram");

TString TTagsHistorgamAction::GetActionType() const {
    return "tags_histogram";
}

bool TTagsHistorgamAction::DeserializeFromJson(const NJson::TJsonValue& json) {
    JREAD_STRING_OPT(json, "title", Title);
    JREAD_STRING_OPT(json, "notifier_name", NotifierName);
    JREAD_FROM_STRING_OPT(json, "entity", ObjectType);
    if (!TJsonProcessor::ReadContainer(json, "groups", GroupFilters)) {
        return false;
    }
    return true;
}

NJson::TJsonValue TTagsHistorgamAction::SerializeToJson() const {
    NJson::TJsonValue result;
    NJson::InsertField(result, "entity", NJson::Stringify(ObjectType));
    JWRITE(result, "title", Title);
    JWRITE(result, "notifier_name", NotifierName);
    TJsonProcessor::WriteContainerArray(result, "groups", GroupFilters);
    return result;
}

NDrive::TScheme TTagsHistorgamAction::GetScheme(const IServerBase& server) const {
    NDrive::TScheme scheme;
    scheme.Add<TFSString>("title", "Тег");
    scheme.Add<TFSVariants>("notifier_name", "Нотификатор").SetVariants(server.GetNotifierNames());
    scheme.Add<TFSVariants>("entity", "entity").InitVariants<NEntityTagsManager::EEntityType>();
    scheme.Add<TFSArray>("groups", "Группы тегов для подсчета статистики").SetElement<TFSString>();
    return scheme;
}

bool TTagsHistorgamAction::DoFinish(const TSet<TString>& objectIds, NAlerts::TFetcherContext& context) {
    auto notifier = context.GetServer()->GetNotifier(NotifierName);
    if (!notifier) {
        return false;
    }

    TMaybe<TString> report;
    if (ObjectType == NEntityTagsManager::EEntityType::User) {
        report = GetReport(objectIds, context.GetServer()->GetDriveAPI()->GetTagsManager().GetUserTags(), context);
    } else {
        report = GetReport(objectIds, context.GetServer()->GetDriveAPI()->GetTagsManager().GetDeviceTags(), context);
    }

    if (!report.Defined()) {
        return false;
    }

    NDrive::INotifier::Notify(notifier, Title + ":\n" + *report);
    return true;
}

