#pragma once

#include "base.h"

class TTagsHistorgamAction : public INotifierActionBase {
public:
    virtual bool DeserializeFromJson(const NJson::TJsonValue& json) override;
    virtual NJson::TJsonValue SerializeToJson() const override;
    virtual NDrive::TScheme GetScheme(const IServerBase& server) const override;
    virtual bool DoFinish(const TSet<TString>& objectIds, NAlerts::TFetcherContext& context) override;
    virtual TString GetActionType() const override;

private:
    template <class TTagsManager>
    TMaybe<TString> GetReport(const TSet<TString>& objectIds, const TTagsManager& tagsManager, NAlerts::TFetcherContext& context) const {
        TMap<TString, TTaggedObject> taggedObjects;
        auto session = tagsManager.BuildSession(true);
        if (!tagsManager.RestoreObjects(objectIds, taggedObjects, session)) {
            return Nothing();
        }

        TVector<ui32> matchedCount(GroupFilters.size(), 0);
        ui32 othersCount = 0;
        for (auto&& [id, object] : taggedObjects) {
            if (context.IsFiltered(object.GetId())) {
                continue;
            }
            bool matched = false;
            for (ui32 i = 0; i < GroupFilters.size(); ++i) {
                auto filter = TTagsFilter::BuildFromString(GroupFilters[i]);
                if (filter.IsMatching(object.GetTags())) {
                    ++matchedCount[i];
                    matched = true;
                }
            }
            if (!matched) {
                ++othersCount;
            }
        }

        TStringStream report;
        report << "Всего объектов: " << objectIds.size() << Endl;
        for (ui32 i = 0; i < GroupFilters.size(); ++i) {
            report << GroupFilters[i] << ": " << matchedCount[i] << Endl;
        }
        report << "Прочие теги: " << othersCount << Endl;
        return report.Str();
    }

private:
    NEntityTagsManager::EEntityType ObjectType = NEntityTagsManager::EEntityType::Car;
    TString NotifierName;
    TString Title;
    TVector<TString> GroupFilters;

    static TFactory::TRegistrator<TTagsHistorgamAction> Registrator;
};

