#pragma once

#include "base.h"


class TTelegramAction : public INotifierActionBase {
    R_READONLY(TString, MessageTemplate);
    R_READONLY(TString, NotifierName);
    R_READONLY(TString, ReportType, "simple");
    R_READONLY(bool, MultiLine, true);
    R_READONLY(TString, HRCheckerName);
public:
    virtual bool DoFinish(const TSet<TString>& objectIds, NAlerts::TFetcherContext& context) override;
    virtual bool DeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue SerializeToJson() const override;
    virtual NDrive::TScheme GetScheme(const IServerBase& server) const override;
private:
    virtual TString BuildObjectReport(const TString& objectId, const NAlerts::TFetcherContext& context) const = 0;
};


class TCarNotifierAction : public TTelegramAction {
public:
    virtual TString GetActionType() const override;
private:
    virtual TString BuildObjectReport(const TString& objectId, const NAlerts::TFetcherContext& context) const override;
    static TFactory::TRegistrator<TCarNotifierAction> Registrator;
};


class TUserNotifierAction : public TTelegramAction {
public:
    virtual TString GetActionType() const override;
private:
    virtual TString BuildObjectReport(const TString& objectId, const NAlerts::TFetcherContext& context) const override;
    static TFactory::TRegistrator<TUserNotifierAction> Registrator;
};
