#pragma once

#include "fetcher.h"
#include "interval_checker.h"

#include <drive/backend/abstract/base.h>

#include <drive/library/cpp/scheme/scheme.h>

#include <rtline/util/types/accessor.h>

#include <util/generic/vector.h>


namespace NAlerts {
    class ICheckerAction {
    public:
        virtual ~ICheckerAction() {}
        void Apply(const TStringBuf& objectId, const TFetchedMap& parameters, TFetcherContext& context) {
            TString key(objectId.Data(), objectId.Size());
            ObjectIds.emplace(key);
            DoApply(key, parameters, context);
        }

        bool Finish(TFetcherContext& context) {
            return DoFinish(ObjectIds, context);
        }

        EAlertEntityType GetEntityType() const {
            return EntityType;
        }

        virtual void SetEntityType(EAlertEntityType entityType) {
            EntityType = entityType;
        }

        virtual bool DoFinish(const TSet<TString>& objectIds, TFetcherContext& context) = 0;

        virtual bool DeserializeFromJson(const NJson::TJsonValue& json) = 0;
        virtual NJson::TJsonValue SerializeToJson() const = 0;
        virtual NDrive::TScheme GetScheme(const IServerBase& /*server*/) const = 0;

    private:
        virtual void DoApply(const TString& /*objectId*/, const TFetchedMap& /*parameters*/, TFetcherContext& /*context*/) {}

    private:
        TSet<TString> ObjectIds;
        EAlertEntityType EntityType = EAlertEntityType::Undefined;
    };

    class TCheckersSet {
    public:
        TCheckersSet() = default;
        bool ApplyFilters(const IServiceDataFetcherConfig::TItems& dataFetcherConfigs, TFetcherContext& context, ICheckerAction& func) const;

    private:
        bool CheckFetched(const TVector<IFetchedIterator::TPtr>& iterators, TFetcherContext& context, ICheckerAction& func, const EAlertEntityType entityType, IServiceDataFetcher::TPtr nextFetcher) const;
    };
}
