#pragma once

#include "condition.h"
#include "fetcher.h"

#include <drive/backend/alerts/actions/base.h>

class IRTBackgroundProcessState;

namespace NAlerts {

    class TAlertContainer {
        IServiceDataFetcherConfig::TItems DataFetchers;
        mutable TCheckersSet Checker;
        NJson::TJsonValue ActionConfig;
        TObjectSharding ShardingPolicy;
        R_READONLY(TMessagesCollector, Errors, {}, mutable);
        bool DebugLogEnabled = false;

        NAlerts::EAlertEntityType EntityType = NAlerts::EAlertEntityType::User;
        const TString RobotUserId;

    public:
        TAlertContainer(NAlerts::EAlertEntityType entityType, const TString& robotUserId)
            : EntityType(entityType)
            , RobotUserId(robotUserId)
        {}

        static void GetScheme(const IServerBase& server, NDrive::TScheme& scheme);
        bool DeserializeFromJson(const NJson::TJsonValue& jsonInfo);
        void SerializeToJson(NJson::TJsonValue& json) const;
        bool Execute(const NDrive::IServer* server, const TInstant startInstant, ICheckerAction* actionExt = nullptr, const TString& stateName = "", TAtomicSharedPtr<IRTBackgroundProcessState> state = nullptr) const;
        template <class T>
        TMaybe<T> CheckAlertSetting(const TString& settingName, const TString& alertName, const NDrive::IServer* server) const;
        static NJson::TJsonValue GetMetaInfo(const IServerBase& server);

        R_READONLY(TString, AlertGroupName, "default");
    };
}
