#include "compiled.h"

namespace NAlerts {
    IFetchedIterator::TFactory::TRegistrator<TCompiledRidesCount> TCompiledRidesCount::Registrator(EFetchedItems::SessionsCount);

    bool TCompiledRidesIteratorConfig::DeserializeFromJson(const NJson::TJsonValue& json) {
        JREAD_DURATION(json, "since", StartDeep);
        JREAD_DURATION(json, "until", FinishDeep);
        /*
        JREAD_DURATION_OPT(json, "riding_min", RidingMinTime);
        JREAD_DURATION_OPT(json, "riding_max", RidingMaxTime);
        JREAD_DURATION_OPT(json, "parking_min", ParkingMinTime);
        JREAD_DURATION_OPT(json, "parking_max", ParkingMaxTime);
        JREAD_DURATION_OPT(json, "acceptance_min", AcceptanceMinTime);
        JREAD_DURATION_OPT(json, "acceptance_max", AcceptanceMaxTime);
        JREAD_DURATION_OPT(json, "history_deep", HistoryDeep);
        */
        return true;

    }

    NJson::TJsonValue TCompiledRidesIteratorConfig::SerializeToJson() const {
        NJson::TJsonValue result;
        JWRITE_DURATION(result, "since", StartDeep);
        JWRITE_DURATION(result, "until", FinishDeep);
        /*
        JWRITE_DURATION(result, "riding_min", RidingMinTime);
        JWRITE_DURATION(result, "riding_max", RidingMaxTime);
        JWRITE_DURATION(result, "parking_min", ParkingMinTime);
        JWRITE_DURATION(result, "parking_max", ParkingMaxTime);
        JWRITE_DURATION(result, "acceptance_min", AcceptanceMinTime);
        JWRITE_DURATION(result, "acceptance_max", AcceptanceMaxTime);
        JWRITE_DURATION(result, "history_deep", HistoryDeep);
        */
        return result;
    }

    NDrive::TScheme TCompiledRidesIteratorConfig::GetScheme(const IServerBase& /*server*/) const {
        NDrive::TScheme scheme;
        scheme.Add<TFSDuration>("since", "starts since");
        scheme.Add<TFSDuration>("until", "starts until");
        /*
        scheme.Add<TFSDuration>("riding_min", "riding_min");
        scheme.Add<TFSDuration>("riding_max", "riding_max");
        scheme.Add<TFSDuration>("parking_min", "parking_min");
        scheme.Add<TFSDuration>("parking_max", "parking_max");
        scheme.Add<TFSDuration>("acceptance_min", "acceptance_min");
        scheme.Add<TFSDuration>("acceptance_max", "acceptance_max");
        scheme.Add<TFSDuration>("history_deep", "history_deep");
        */
        return scheme;
    }
}
