#pragma once

#include "iterators.h"

#include <drive/backend/billing/interfaces/entities.h>
#include <drive/backend/billing/interfaces/payments.h>

namespace NAlerts {

    class TSpentSumIteratorConfig : public IIteratorConfig {
        using TBase = IIteratorConfig;
        R_READONLY(TSet<EBillingType>, BillingTypes);
        R_READONLY(TSet<NDrive::NTrustClient::EPaymentStatus>, TrustStatuses);
        R_READONLY(TDuration, Start);
        R_READONLY(TDuration, End);
        R_READONLY(bool, IncludeActive, true);

    public:
        using TBase::TBase;
        virtual bool DeserializeFromJson(const NJson::TJsonValue& json) override;
        virtual NJson::TJsonValue SerializeToJson() const override;
        virtual NDrive::TScheme GetScheme(const IServerBase& /*server*/) const override;
    };

    class TSpentSumIterator : public TContainerIteratorBase {
        using TBase = TContainerIteratorBase;
        static IFetchedIterator::TFactory::TRegistrator<TSpentSumIterator> Registrator;

    public:
        using TBase::TBase;

        virtual EFetchedItems GetField() const override {
            return EFetchedItems::SpentSum;
        }

        bool ExtractData(TFetchedValue& data) const override;
    };
}
