#pragma once
#include "iterators.h"

#include <drive/backend/data/proto/tags.pb.h>

#include <rtline/util/json_processing.h>
#include <rtline/util/types/accessor.h>

#include <drive/backend/data/dictionary_tags.h>

namespace NAlerts {
    class TDictionaryTagFieldIteratorConfig: public IIteratorConfig {
    private:
        using TBase = IIteratorConfig;
        R_READONLY(TString, TagName);
        R_READONLY(TString, FieldName);
        R_READONLY(TSet<TString>, FieldValues);

    public:
        using TBase::TBase;
        virtual bool DeserializeFromJson(const NJson::TJsonValue& json) override;
        virtual NJson::TJsonValue SerializeToJson() const override;
        virtual NDrive::TScheme GetScheme(const IServerBase& /*server*/) const override;
    };

    class TDictionaryTagFieldIterator: public TContainerIteratorBase {
    private:
        using TBase = TContainerIteratorBase;
        static IFetchedIterator::TFactory::TRegistrator<TDictionaryTagFieldIterator> Registrator;

    public:
        using TBase::TBase;

        virtual EFetchedItems GetField() const override {
            return EFetchedItems::DictionaryTag;
        }

        virtual bool InitByObjects(IFetchedIterator& objectIterator) override;
        bool ExtractData(TFetchedValue& data) const override;

    private:
        TMap<TString, ui32> ObjectFieldsCount;
    };
}
