#pragma once
#include "iterators.h"

#include <drive/backend/data/event_tag.h>

namespace NAlerts {
    class TEventTagConfig: public IIteratorConfig {
    private:
        using TBase = IIteratorConfig;
        R_READONLY(TString, TagName);
        R_READONLY(TVector<TString>, EventNames);

    public:
        using TBase::TBase;
        virtual bool DeserializeFromJson(const NJson::TJsonValue& json) override;
        virtual NJson::TJsonValue SerializeToJson() const override;
        virtual NDrive::TScheme GetScheme(const IServerBase& /*server*/) const override;
    };

    class IEventTagIterator: public TContainerIteratorBase {
    protected:
        using TBase = TContainerIteratorBase;

    public:
        using TBase::TBase;
        virtual bool ExtractData(TFetchedValue& data) const;

    protected:
        virtual TExpected<TFetchedValue, TString> ProcessEventTags(const TVector<TDBTag>& tags) const = 0;
    };

    class TEventTagEventCountIterator: public IEventTagIterator {
    private:
        using TBase = IEventTagIterator;
        static IFetchedIterator::TFactory::TRegistrator<TEventTagEventCountIterator> Registrator;

    public:
        using TBase::TBase;

        virtual EFetchedItems GetField() const override {
            return EFetchedItems::EventTagEventCount;
        }

    protected:
        virtual TExpected<TFetchedValue, TString> ProcessEventTags(const TVector<TDBTag>& tags) const override;
    };

    class TEventTagPresentEventsConfig: public TEventTagConfig {
    private:
        using TBase = TEventTagConfig;
        R_READONLY(bool, CheckOrder, false);

    public:
        using TBase::TBase;

    public:
        virtual bool DeserializeFromJson(const NJson::TJsonValue& json) override;
        virtual NJson::TJsonValue SerializeToJson() const override;
        virtual NDrive::TScheme GetScheme(const IServerBase& /*server*/) const override;
    };

    class TEventTagPresentEventsIterator: public IEventTagIterator {
    private:
        using TBase = IEventTagIterator;
        static IFetchedIterator::TFactory::TRegistrator<TEventTagPresentEventsIterator> Registrator;

    public:
        using TBase::TBase;

        virtual EFetchedItems GetField() const override {
            return EFetchedItems::EventTagPresentEvents;
        }

    protected:
        virtual TExpected<TFetchedValue, TString> ProcessEventTags(const TVector<TDBTag>& tags) const override;
    };

    class TEventTagMetaCountConfig: public TEventTagConfig {
    private:
        using TBase = TEventTagConfig;
        R_READONLY(TString, FieldPath);
        R_READONLY(bool, IgnoreEmpty, true);

    public:
        using TBase::TBase;

    public:
        virtual bool DeserializeFromJson(const NJson::TJsonValue& json) override;
        virtual NJson::TJsonValue SerializeToJson() const override;
        virtual NDrive::TScheme GetScheme(const IServerBase& /*server*/) const override;
    };

    class TEventTagMetaCountIterator: public IEventTagIterator {
    private:
        using TBase = IEventTagIterator;
        static IFetchedIterator::TFactory::TRegistrator<TEventTagMetaCountIterator> Registrator;

    public:
        using TBase::TBase;

        virtual EFetchedItems GetField() const override {
            return EFetchedItems::EventTagMetaCount;
        }

    protected:
        virtual TExpected<TFetchedValue, TString> ProcessEventTags(const TVector<TDBTag>& tags) const override;
    };
}
