#include "iterators.h"

#include <drive/backend/history_iterator/history_iterator.h>

class TLastHistoryRideIteratorConfig : public NAlerts::IIteratorConfig {
private:
    using TBase = IIteratorConfig;

public:
    using TBase::TBase;

    bool DeserializeFromJson(const NJson::TJsonValue& json) override;
    NJson::TJsonValue SerializeToJson() const override;
    NDrive::TScheme GetScheme(const IServerBase& server) const override;

private:
    R_READONLY(TDuration, HistoryDepth, TDuration::Seconds(20));

private:
    static NAlerts::IIteratorConfig::TFactory::TRegistrator<TLastHistoryRideIteratorConfig> Registrator;
};

class TLastHistoryRideIterator : public NAlerts::TContainerIteratorBase {
private:
    using TBase = TContainerIteratorBase;

public:
    using TBase::TBase;

    NAlerts::EFetchedItems GetField() const override {
        return NAlerts::EFetchedItems::LastHistoryRide;
    }

    bool ExtractData(NAlerts::TFetchedValue& data) const override;

private:
    static NAlerts::IFetchedIterator::TFactory::TRegistrator<TLastHistoryRideIterator> Registrator;
};
