#include "iterators.h"

#include <drive/backend/device_snapshot/manager.h>

namespace NAlerts {
    class TLagIteratorConfig : public IIteratorConfig {
    private:
        using TBase = IIteratorConfig;

    public:
        using TBase::TBase;
        bool DeserializeFromJson(const NJson::TJsonValue& json) override {
            Y_UNUSED(json);
            return true;
        }
        NJson::TJsonValue SerializeToJson() const override {
            return {};
        }
        NDrive::TScheme GetScheme(const IServerBase& server) const override {
            Y_UNUSED(server);
            return {};
        }

    private:
        static TFactory::TRegistrator<TLagIteratorConfig> Registrator;
    };

    class TLagIterator : public TContainerIteratorBase {
    private:
        using TBase = TContainerIteratorBase;

    public:
        using TBase::TBase;

        EFetchedItems GetField() const override {
            return EFetchedItems::Lag;
        }

        TString GetCarId() const {
            auto session = GetDataCurrent<::IEventsSession<TCarTagHistoryEvent>>();
            if (!session) {
                return { GetObjectId().Data(), GetObjectId().Size() };
            }
            return session->GetObjectId();
        }

        bool ExtractData(TFetchedValue& data) const override {
            auto carId = GetCarId();
            auto snapshot = Context.GetServer()->GetSnapshotsManager().GetSnapshot(carId);
            auto speed = snapshot.GetSensor(VEGA_SPEED);
            if (!speed) {
                return false;
            }
            auto lag = Now() - speed->Timestamp;
            data = lag.Seconds();
            return true;
        }

    private:
        static IFetchedIterator::TFactory::TRegistrator<TLagIterator> Registrator;
    };
}

NAlerts::IIteratorConfig::TFactory::TRegistrator<NAlerts::TLagIteratorConfig> NAlerts::TLagIteratorConfig::Registrator(EFetchedItems::Lag);
NAlerts::IFetchedIterator::TFactory::TRegistrator<NAlerts::TLagIterator> NAlerts::TLagIterator::Registrator(EFetchedItems::Lag);
