#include "iterators.h"

#include <drive/telematics/api/sensor/interface.h>

class TLocationIteratorConfig: public NAlerts::IIteratorConfig {
private:
    using TBase = IIteratorConfig;

public:
    R_OPTIONAL(TSet<TString>, IncludedAreaIds);
    R_OPTIONAL(TSet<TString>, ExcludedAreaIds);
    R_OPTIONAL(TSet<TString>, IncludedLocationTags);
    R_OPTIONAL(TSet<TString>, ExcludedLocationTags);
    R_OPTIONAL(NDrive::TZoneIds, IncludedZoneIds);
    R_OPTIONAL(NDrive::TZoneIds, ExcludedZoneIds);
    R_FIELD(TDuration, LocationQueryTimeout, TDuration::Seconds(10));
    R_FIELD(TString, LocationName);
    R_FIELD(bool, LoggingEnabled, false);

public:
    using TBase::TBase;

    bool DeserializeFromJson(const NJson::TJsonValue& json) override;
    NJson::TJsonValue SerializeToJson() const override;
    NDrive::TScheme GetScheme(const IServerBase& /*server*/) const override;

private:
    static NAlerts::IIteratorConfig::TFactory::TRegistrator<TLocationIteratorConfig> Registrator;
};

class TLocationIterator: public NAlerts::TContainerIteratorBase {
private:
    using TBase = TContainerIteratorBase;

public:
    using TBase::TBase;

    TString GetCarId() const {
        auto session = GetDataCurrent<::IEventsSession<TCarTagHistoryEvent>>();
        if (!session) {
            return ToString(GetObjectId());
        }
        return session->GetObjectId();
    }

    NAlerts::EFetchedItems GetField() const override {
        return NAlerts::EFetchedItems::Location;
    }

    bool ExtractData(NAlerts::TFetchedValue& data) const override;
    bool InitByObjects(IFetchedIterator& objectIterator) override;

private:
    NThreading::TFuture<NDrive::ISensorApi::TLocations> Locations;
    TInstant WaitDeadline;

private:
    static NAlerts::IFetchedIterator::TFactory::TRegistrator<TLocationIterator> Registrator;
};
