#include "billing.h"
#include "chat_info.h"
#include "compiled.h"
#include "compiled_bill.h"
#include "dictionary_tags.h"
#include "event_tags.h"
#include "iterators.h"
#include "maintenance.h"
#include "requests.h"
#include "tags.h"
#include "tags_filter.h"
#include "user_info.h"

#include <drive/backend/alerts/fetcher.h>

namespace NAlerts {
    IIteratorConfig::TFactory::TRegistrator<TTimeIteratorConfig> Registrator1(EFetchedItems::LastActionDelta);
    IIteratorConfig::TFactory::TRegistrator<TLandingsIteratorConfig> Registrator3(EFetchedItems::LandingAcceptanceDelta);
    IIteratorConfig::TFactory::TRegistrator<TChatInfoIteratorConfig> Registrator4(EFetchedItems::ChatUnreadMessages);
    IIteratorConfig::TFactory::TRegistrator<TCompiledRidesIteratorConfig> Registrator5(EFetchedItems::SessionsCount);
    IIteratorConfig::TFactory::TRegistrator<TTagsFilterIteratorConfig> Registrator6(EFetchedItems::TagsFilter);
    IIteratorConfig::TFactory::TRegistrator<TChatInfoIteratorConfig> Registrator7(EFetchedItems::ChatLastMessageDelta);
    IIteratorConfig::TFactory::TRegistrator<TMaintenanceIteratorConfig> Registrator8(EFetchedItems::MaintenanceTime);
    IIteratorConfig::TFactory::TRegistrator<TMaintenanceIteratorConfig> Registrator9(EFetchedItems::MaintenanceMileageDelta);
    IIteratorConfig::TFactory::TRegistrator<TChatInfoIteratorConfig> Registrator10(EFetchedItems::ChatIsNew);
    IIteratorConfig::TFactory::TRegistrator<TRequestTimeIteratorConfig> Registrator11(EFetchedItems::LastRequestTime);
    IIteratorConfig::TFactory::TRegistrator<TDebtIteratorConfig> Registrator12(EFetchedItems::BillingTagSum);
    IIteratorConfig::TFactory::TRegistrator<TDebtIteratorConfig> Registrator13(EFetchedItems::BillingDebtAge);
    IIteratorConfig::TFactory::TRegistrator<TTagFieldCountIteratorConfig> Registrator14(EFetchedItems::TagField);
    IIteratorConfig::TFactory::TRegistrator<TSpentSumIteratorConfig> Registrator15(EFetchedItems::SpentSum);
    IIteratorConfig::TFactory::TRegistrator<TEventTagConfig> Registrator16(EFetchedItems::EventTagEventCount);
    IIteratorConfig::TFactory::TRegistrator<TEventTagPresentEventsConfig> Registrator17(EFetchedItems::EventTagPresentEvents);
    IIteratorConfig::TFactory::TRegistrator<TEventTagMetaCountConfig> Registrator18(EFetchedItems::EventTagMetaCount);
    IIteratorConfig::TFactory::TRegistrator<TScoringTagIteratorConfig> Registrator19(EFetchedItems::ScoringTag);
    IIteratorConfig::TFactory::TRegistrator<TDictionaryTagFieldIteratorConfig> Registrator20(EFetchedItems::DictionaryTag);
    IIteratorConfig::TFactory::TRegistrator<TEmptyConfig> Registrator21(EFetchedItems::Main);
    IIteratorConfig::TFactory::TRegistrator<TEmptyConfig> Registrator22(EFetchedItems::RegApprovedDelta);
    IIteratorConfig::TFactory::TRegistrator<TEmptyConfig> Registrator23(EFetchedItems::SessionStateTime);
    IIteratorConfig::TFactory::TRegistrator<TEmptyConfig> Registrator24(EFetchedItems::SessionBill);
    IIteratorConfig::TFactory::TRegistrator<TEmptyConfig> Registrator25(EFetchedItems::IsPhoneVerified);
    IIteratorConfig::TFactory::TRegistrator<TEmptyConfig> Registrator26(EFetchedItems::IsMailVerified);
    IIteratorConfig::TFactory::TRegistrator<TEmptyConfig> Registrator27(EFetchedItems::BindMailTime);
    IIteratorConfig::TFactory::TRegistrator<TEmptyConfig> Registrator28(EFetchedItems::CreditCardsCount);
    IIteratorConfig::TFactory::TRegistrator<TEmptyConfig> Registrator29(EFetchedItems::PackOfferRemainingDuration);
    IIteratorConfig::TFactory::TRegistrator<TEmptyConfig> Registrator30(EFetchedItems::PackOfferRemainingDistance);
    IIteratorConfig::TFactory::TRegistrator<TEmptyConfig> Registrator31(EFetchedItems::ActualSessionsCount);
    IIteratorConfig::TFactory::TRegistrator<TTagFieldValueIteratorConfig> Registrator32(EFetchedItems::TagFieldValue);
    IIteratorConfig::TFactory::TRegistrator<TSLADeadlineIteratorConfig> Registrator33(EFetchedItems::SLADeadline);
}
