#include "requests.h"

namespace NAlerts {
    IFetchedIterator::TFactory::TRegistrator<TRequestTimeIterator> TRequestTimeIterator::Registrator(EFetchedItems::LastRequestTime);

    bool TRequestTimeIteratorConfig::DeserializeFromJson(const NJson::TJsonValue& json) {
        JREAD_DURATION_OPT(json, "history_deep", HistoryDeep);
        JREAD_UINT_OPT(json, "max_requests_count", MaxRequestsCount);
        TJsonProcessor::ReadContainer(json, "sources", Sources, true);
        JREAD_DURATION_OPT(json, "request_timeout", RequestTimeout);
        return true;
    }

    NJson::TJsonValue TRequestTimeIteratorConfig::SerializeToJson() const {
        NJson::TJsonValue result;
        TJsonProcessor::WriteDurationString(result, "history_deep", HistoryDeep, TDuration::Max());
        TJsonProcessor::WriteContainerArray(result, "sources", Sources);
        TJsonProcessor::Write(result, "max_requests_count", MaxRequestsCount);
        TJsonProcessor::Write(result, "request_timeout", RequestTimeout);
        return result;
    }

    NDrive::TScheme TRequestTimeIteratorConfig::GetScheme(const IServerBase& /*server*/) const {
        NDrive::TScheme scheme;
        scheme.Add<TFSDuration>("history_deep", "Глубина проверки истории");
        scheme.Add<TFSNumeric>("max_requests_count", "Максимальное число запросов").SetDefault(100);
        scheme.Add<TFSArray>("sources", "Handlers").SetElement<TFSString>();
        scheme.Add<TFSDuration>("request_timeout", "Время на запрос").SetDefault(TDuration::Seconds(2));
        return scheme;
    }
}
