#include "tags_filter.h"

namespace NAlerts {
    IFetchedIterator::TFactory::TRegistrator<TTagsFilterChecker> TTagsFilterChecker::Registrator(EFetchedItems::TagsFilter);

    bool TTagsFilterIteratorConfig::DeserializeFromJson(const NJson::TJsonValue& json) {
        JREAD_STRING_OPT(json, "filter", Filter);
        return true;

    }

    NJson::TJsonValue TTagsFilterIteratorConfig::SerializeToJson() const {
        NJson::TJsonValue result;
        JWRITE(result, "filter", Filter);
        return result;
    }

    NDrive::TScheme TTagsFilterIteratorConfig::GetScheme(const IServerBase& /*server*/) const {
        NDrive::TScheme scheme;
        scheme.Add<TFSDuration>("filter", "filter");
        return scheme;
    }
}
