#pragma once

#include "iterators.h"

namespace NAlerts {
    class TTagsFilterIteratorConfig : public IIteratorConfig {
    public:
        using TBase = IIteratorConfig;
        R_READONLY(TString, Filter);

    public:
        using TBase::TBase;
        virtual bool DeserializeFromJson(const NJson::TJsonValue& json) override;
        virtual NJson::TJsonValue SerializeToJson() const override;
        virtual NDrive::TScheme GetScheme(const IServerBase& /*server*/) const override;
    };

    class TTagsFilterChecker : public TContainerIteratorBase {
    private:
        using TBase = TContainerIteratorBase;

    private:
        static IFetchedIterator::TFactory::TRegistrator<TTagsFilterChecker> Registrator;

    public:
        using TBase::TBase;

        virtual EFetchedItems GetField() const override {
            return EFetchedItems::TagsFilter;
        }

        bool ExtractData(TFetchedValue& data) const override {
            auto config = TBase::template GetConfigAs<TTagsFilterIteratorConfig>();
            if (!config) {
                return false;
            }
            const TFetcherContext& context = TBase::Context;
            if (GetEntityType() != EAlertEntityType::User) { //TODO: all entity types
                return false;
            }
            const auto& tagsManager = context.GetServer()->GetDriveAPI()->GetTagsManager().GetUserTags();
            TString objectId(TBase::GetObjectId());
            auto taggedObject = tagsManager.GetCachedObject(objectId);
            if (!taggedObject) {
                taggedObject = TTaggedUser();
            }
            auto filter = TTagsFilter::BuildFromString(config->GetFilter());
            if (filter.IsMatching(taggedObject->GetTags())) {
                data = 1;
            } else {
                data = 0;
            }
            return true;
        }
    };
}
