#include "car_tags.h"

#include <drive/backend/database/drive_api.h>

TTagsFetcherConfig::TFactory::TRegistrator<TCarTagsFetcherConfig> TCarTagsFetcherConfig::Registrator(TCarTagsFetcherConfig::GetType());


bool TCarTagsDataFetcher::DoFetch(const NAlerts::TFetcherContext& context) {
    if (ObjectsIds.size() > 0) {
        return true;
    }
    if (GetAllowedCarIds().Defined()) {
        TSet<TString> filteredObjectIds;
        if (!Config.GetCarsFilter().GetAllowedCarIds(filteredObjectIds, context.GetServer(), context.GetFetchInstant())) {
            return false;
        }
        for (auto&& filteredId : filteredObjectIds) {
            if (GetAllowedCarIds()->contains(filteredId)) {
                ObjectsIds.insert(std::move(filteredId));
            }
        }
    } else {
        if (!Config.GetCarsFilter().GetAllowedCarIds(ObjectsIds, context.GetServer(), context.GetFetchInstant())) {
            return false;
        }
    }

    return true;
}

bool TCarTagsFetcherConfig::DoDeserializeFromJson(const NJson::TJsonValue& json) {
    if (json.Has("filter") && !CarsFilter.DeserializeFromJson(json["filter"])) {
        return false;
    }
    return true;
}

NJson::TJsonValue TCarTagsFetcherConfig::DoSerializeToJson() const {
    NJson::TJsonValue result;
    JWRITE(result, "filter", CarsFilter.SerializeToJson());
    return result;
}

NDrive::TScheme TCarTagsFetcherConfig::DoGetScheme(const IServerBase& server) const {
    NDrive::TScheme scheme;
    scheme.Add<TFSStructure>("filter", "Фильтр объектов").SetStructure(TCarsFilter::GetScheme(server.GetAsSafe<NDrive::IServer>()));
    return scheme;
}

TString TCarTagsFetcherConfig::GetSchemeDescription() const {
    return "Фильтрация машин по тегам";
}

NAlerts::EDataFetcherType TCarTagsFetcherConfig::GetFetcherType() const {
    return GetType();
}

NAlerts::IServiceDataFetcher::TPtr TCarTagsFetcherConfig::BuildFetcher() const {
    return new TCarTagsDataFetcher(*this);
}
