#pragma once

#include "interfaces.h"
#include "object_tags.h"


class TCarTagsFetcherConfig : public NAlerts::IServiceDataFetcherConfig {
    R_READONLY(TCarsFilter, CarsFilter);

public:
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& json) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& /*server*/) const override;

    virtual TString GetSchemeDescription() const override;
    virtual NAlerts::EDataFetcherType GetFetcherType() const override;
    virtual NAlerts::EAlertEntityType GetEntityType() const override {
        return NAlerts::EAlertEntityType::Car;
    }
    virtual NAlerts::IServiceDataFetcher::TPtr BuildFetcher() const override;

private:
    static NAlerts::EDataFetcherType GetType() {
        return NAlerts::EDataFetcherType::ECarTags;
    }
    static TFactory::TRegistrator<TCarTagsFetcherConfig> Registrator;
};


class TCarTagsDataFetcher : public NAlerts::IIdsDataFetcher {
public:
    TCarTagsDataFetcher(const TCarTagsFetcherConfig& config)
        : IIdsDataFetcher(config)
        , Config(config) {}

    virtual const TSet<TString>& GetObjects() const override {
        return ObjectsIds;
    }

protected:
    virtual bool DoFetch(const NAlerts::TFetcherContext& context) override;

private:
    TCarTagsFetcherConfig Config;
    TSet<TString> ObjectsIds;
};
