#pragma once

#include "interfaces.h"

#include <drive/backend/alerts/condition.h>

#include <drive/backend/users/user.h>
#include <drive/backend/users/user_documents.h>

#include <rtline/util/types/accessor.h>

class TChatUsersFetcherConfig : public NAlerts::IServiceDataFetcherConfig {
public:
    class TConfidencesBlock {
        R_READONLY(TVector<TRecognitionConfidenceData::EDocumentField>, Fields);
        R_READONLY(NUserDocument::EType, PhotoType, NUserDocument::EType::Unknown);
        R_READONLY(double, MinAvgConfidence, 0);
        R_READONLY(double, MinEachConfidence, 0);

    public:
        bool DeserializeFromJson(const NJson::TJsonValue& json);
        NJson::TJsonValue SerializeToJson() const;
    };

private:
    using TPhotoStatusesMapping = TMap<NUserDocument::EType, NUserDocument::EVerificationStatus>;

    R_READONLY(TString, ChatId);
    R_READONLY(TString, ChatTopic);
    R_READONLY(TSet<TString>, NodeNames);
    R_READONLY(bool, ExcludeActiveTwins, false);
    R_READONLY(TString, BaseStatus, "onboarding");

    R_READONLY(TPhotoStatusesMapping, PhotoStatuses);
    R_READONLY(TVector<TConfidencesBlock>, CVFilterBlocks);

public:
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& json) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& /*server*/) const override;
    virtual NAlerts::EDataFetcherType GetFetcherType() const override {
        return NAlerts::EDataFetcherType::EChatState;
    }
    virtual NAlerts::EAlertEntityType GetEntityType() const override {
        return NAlerts::EAlertEntityType::User;
    }
    virtual NAlerts::IServiceDataFetcher::TPtr BuildFetcher() const override;
    virtual TString GetSchemeDescription() const override {
        return "";
    }
private:
    static TFactory::TRegistrator<TChatUsersFetcherConfig> Registrator;
};


class TChatUsersFetcher : public NAlerts::IUserDataFetcher {
public:
    TChatUsersFetcher(const TChatUsersFetcherConfig& config)
        : IUserDataFetcher(config)
        , Config(config) {}

    virtual const TVector<TDriveUserData>& GetObjects() const override {
        return Users;
    }

protected:
    virtual bool DoFetch(const NAlerts::TFetcherContext& context) override;

private:
    R_READONLY(TChatUsersFetcherConfig, Config);
    mutable TVector<TDriveUserData> Users;
};
