#pragma once

#include <drive/backend/alerts/fetcher.h>

#include <drive/backend/database/history/session.h>
#include <drive/backend/tags/tag.h>
#include <drive/backend/users/user.h>

namespace NAlerts {

    class IIdsDataFetcher : public IServiceDataFetcher {
    public:
        using TContainerType = TSet<TString>;
        using IServiceDataFetcher::IServiceDataFetcher;

        virtual const TContainerType& GetObjects() const = 0;

        static TStringBuf GetObjectId(const typename TContainerType::const_iterator& iterator, const EAlertEntityType) {
             return *iterator;
        }

        static TStringBuf GetObjectData(const typename TContainerType::const_iterator& iterator) {
             return *iterator;
        }
    };

    class IUserDataFetcher : public IServiceDataFetcher {
    public:
        using TContainerType = TVector<TDriveUserData>;
        using IServiceDataFetcher::IServiceDataFetcher;

        virtual const TContainerType& GetObjects() const = 0;

        static TStringBuf GetObjectId(const typename TContainerType::const_iterator& iterator, const EAlertEntityType) {
            return iterator->GetUserId();
        }

        static const TDriveUserData& GetObjectData(const typename TContainerType::const_iterator& iterator) {
             return *iterator;
        }
    };

    class ISessionsDataFetcher : public IServiceDataFetcher {
    public:
        using TContainerType = TVector<::IEventsSession<TTagHistoryEvent>::TPtr>;
        using IServiceDataFetcher::IServiceDataFetcher;

        virtual const TContainerType& GetObjects() const = 0;

        static TStringBuf GetObjectId(const typename TContainerType::const_iterator& iterator, const EAlertEntityType entityType) {
            switch (entityType) {
            case EAlertEntityType::User:
                return (*iterator)->GetUserId();
            case EAlertEntityType::Car:
                return (*iterator)->GetObjectId();
            default:
                return (*iterator)->GetSessionId();
            }
        }

        static ::IEventsSession<TCarTagHistoryEvent>::TPtr GetObjectData(const typename TContainerType::const_iterator& iterator) {
            return *iterator;
        }
    };
} // namespace NAlerts
