#pragma once

#include "interfaces.h"

#include <drive/backend/alerts/condition.h>

#include <drive/backend/tags/tags_search.h>

#include <rtline/util/types/accessor.h>

class IEntityTagsManager;

class TTagsFetcherConfig : public NAlerts::IServiceDataFetcherConfig {
    R_READONLY(TTagsSearchRequest, SearchRequest);
    R_READONLY(NAlerts::TChainContext, ChainContext);

public:
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& json) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& /*server*/) const override;

    virtual TString GetSchemeDescription() const override;
    virtual NAlerts::EDataFetcherType GetFetcherType() const override;
    virtual NAlerts::IServiceDataFetcher::TPtr BuildFetcher() const override;

    virtual NAlerts::EAlertEntityType GetEntityType() const override {
        return EntityType;
    }

private:
    static NAlerts::EDataFetcherType GetType() {
        return NAlerts::EDataFetcherType::EObjectTags;
    }
    static TFactory::TRegistrator<TTagsFetcherConfig> Registrator;

private:
    NAlerts::EAlertEntityType EntityType = NAlerts::EAlertEntityType::Car;
};


class TTagsDataFetcher : public NAlerts::IIdsDataFetcher {
public:
    TTagsDataFetcher(const TTagsFetcherConfig& config)
        : IIdsDataFetcher(config)
        , Config(config) {}

    virtual const TSet<TString>& GetObjects() const override {
        return ObjectsIds;
    }

protected:
    virtual bool DoFetch(const NAlerts::TFetcherContext& context) override;

private:
    TTagsFetcherConfig Config;
    TMaybe<TTagsSearchResult> SearchResult;
    TSet<TString> ObjectsIds;
};
