#pragma once

#include "interfaces.h"

class TSensorHistoryIdFetcherConfig: public NAlerts::IServiceDataFetcherConfig {
public:
    R_FIELD(TString, Query);
    R_FIELD(TDuration, Timeout, TDuration::Seconds(100));

public:
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& json) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& /*server*/) const override;

    virtual TString GetSchemeDescription() const override {
        return "Query sensor history ClickHouse";
    }
    virtual NAlerts::EDataFetcherType GetFetcherType() const override {
        return GetType();
    }
    virtual NAlerts::EAlertEntityType GetEntityType() const override {
        return NAlerts::EAlertEntityType::Car;
    }
    virtual NAlerts::IServiceDataFetcher::TPtr BuildFetcher() const override;

private:
    static NAlerts::EDataFetcherType GetType() {
        return NAlerts::EDataFetcherType::ESensorHistoryIds;
    }
    static TFactory::TRegistrator<TSensorHistoryIdFetcherConfig> Registrator;
};

class TSensorHistoryIdFetcher: public NAlerts::IIdsDataFetcher {
public:
    TSensorHistoryIdFetcher(const TSensorHistoryIdFetcherConfig& config)
        : IIdsDataFetcher(config)
        , Config(config)
    {
    }

    virtual const TSet<TString>& GetObjects() const override {
        return ObjectIds;
    }

protected:
    virtual bool DoFetch(const NAlerts::TFetcherContext& context) override;

private:
    TSensorHistoryIdFetcherConfig Config;
    TSet<TString> ObjectIds;
};
