#include "trace_tags.h"

#include <drive/backend/database/drive_api.h>
#include <drive/backend/tags/tags_manager.h>

TTraceTagsConfig::TFactory::TRegistrator<TTraceTagsConfig> TTraceTagsConfig::Registrator(NAlerts::EDataFetcherType::ETraceTags);

bool TTraceTagsConfig::DoDeserializeFromJson(const NJson::TJsonValue& json) {
    return NJson::ParseField(json, "tag_names", TagNames) && !TagNames.empty();
}

NJson::TJsonValue TTraceTagsConfig::DoSerializeToJson() const {
    NJson::TJsonValue result;
    NJson::InsertField(result, "tag_names", TagNames);
    return result;
}

NDrive::TScheme TTraceTagsConfig::DoGetScheme(const IServerBase& /* server */) const {
    NDrive::TScheme scheme;
    scheme.Add<TFSArray>("tag_names", "Теги").SetElement<TFSString>();
    return scheme;
}


NAlerts::IServiceDataFetcher::TPtr TTraceTagsConfig::BuildFetcher() const {
    return MakeAtomicShared<TTraceTagsFetcher>(*this);
}

bool TTraceTagsFetcher::DoFetch(const NAlerts::TFetcherContext& context) {
    if (!ObjectIds.empty()) {
        return false;
    }
    TDBTags tags;
    const TTraceTagsManager& traceTagsManager = context.GetServer()->GetDriveAPI()->GetTagsManager().GetTraceTags();
    auto session = traceTagsManager.BuildSession(/* readOnly = */ true);
    if (!traceTagsManager.RestoreTags({}, MakeVector(Config.GetTagNames()), tags, session)) {
        return false;
    }
    Transform(tags.begin(), tags.end(), std::inserter(ObjectIds, ObjectIds.begin()), [](const auto& tag) { return tag.GetObjectId(); });
    return true;
}
