#pragma once

#include "interfaces.h"

#include <drive/backend/alerts/condition.h>
#include <drive/backend/users/user.h>

#include <rtline/util/types/accessor.h>


class TTraceTagsConfig : public NAlerts::IServiceDataFetcherConfig {
private:
    R_READONLY(TSet<TString>, TagNames);

public:
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& json) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& /*server*/) const override;
    virtual NAlerts::IServiceDataFetcher::TPtr BuildFetcher() const override;
    virtual NAlerts::EDataFetcherType GetFetcherType() const override {
        return NAlerts::EDataFetcherType::ETraceTags;
    }
    virtual NAlerts::EAlertEntityType GetEntityType() const override {
        return NAlerts::EAlertEntityType::Session;
    }
    virtual TString GetSchemeDescription() const override {
        return "";
    }

private:
    static TFactory::TRegistrator<TTraceTagsConfig> Registrator;
};


class TTraceTagsFetcher : public NAlerts::IIdsDataFetcher {
public:
    TTraceTagsFetcher(const TTraceTagsConfig& config)
        : IIdsDataFetcher(config)
        , Config(config)
    {
    }

    virtual const TContainerType& GetObjects() const override {
        return ObjectIds;
    }

protected:
    virtual bool DoFetch(const NAlerts::TFetcherContext& context) override;

private:
    R_READONLY(TTraceTagsConfig, Config);
    R_READONLY(TSet<TString>, ObjectIds);
};
