#pragma once

#include "interfaces.h"

#include <drive/backend/alerts/condition.h>
#include <drive/backend/users/user.h>

#include <rtline/util/types/accessor.h>


class TTraceTagsHistoryConfig : public NAlerts::IServiceDataFetcherConfig {
public:
    class TQueryOptions{
    private:
        R_OPTIONAL(TSet<EObjectHistoryAction>, Actions);
        R_OPTIONAL(TSet<TString>, Performers);
        R_OPTIONAL(TSet<TString>, Tags);
        R_OPTIONAL(TSet<TString>, TagIds);
        R_OPTIONAL(TSet<TString>, OriginatorIds);
        R_OPTIONAL(TSet<TString>, UserIds);

        R_FIELD(bool, Descending, false);

    public:
        bool DeserializeFromJson(const NJson::TJsonValue& json);
        NJson::TJsonValue SerializeToJson() const;
        static NDrive::TScheme GetScheme(const IServerBase& /*server*/);

        TTagEventsManager::TQueryOptions GetQueryRequest() const;
    };

private:
    R_READONLY(TQueryOptions, QueryOptions);
    R_OPTIONAL(TQueryOptions, SubtractQueryOptions);

    R_OPTIONAL(TCarsFilter, CarsFilter);
    R_READONLY(TString, TraceFilter);

public:
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& json) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& /*server*/) const override;
    virtual NAlerts::IServiceDataFetcher::TPtr BuildFetcher() const override;
    virtual NAlerts::EDataFetcherType GetFetcherType() const override {
        return NAlerts::EDataFetcherType::ETraceTagsHistory;
    }
    virtual NAlerts::EAlertEntityType GetEntityType() const override {
        return NAlerts::EAlertEntityType::Session;
    }
    virtual TString GetSchemeDescription() const override {
        return "";
    }
private:
    static TFactory::TRegistrator<TTraceTagsHistoryConfig> Registrator;
};

class TRTCommonAlertsState;
class TTraceTagsHistoryFetcher : public NAlerts::IIdsDataFetcher {
public:
    TTraceTagsHistoryFetcher(const TTraceTagsHistoryConfig& config)
        : IIdsDataFetcher(config)
        , Config(config)
    {
    }

    virtual const TContainerType& GetObjects() const override {
        return ObjectIds;
    }

protected:
    virtual bool DoFetch(const NAlerts::TFetcherContext& context) override;

private:
    R_READONLY(TTraceTagsHistoryConfig, Config);
    R_READONLY(TSet<TString>, ObjectIds);
};
