#pragma once

#include "interfaces.h"

#include <drive/backend/alerts/condition.h>

#include <drive/backend/users/user.h>

#include <rtline/util/types/accessor.h>


class TUsersFetcherConfig : public NAlerts::IServiceDataFetcherConfig {
private:
    R_READONLY(bool, CheckRidings, true);
    R_READONLY(bool, WithoutRidings, true);
    R_READONLY(TSet<TString>, Statuses);
    R_READONLY(TSet<TString>, Actions);
    R_READONLY(TSet<TString>, Roles);
    R_READONLY(TSet<TString>, SpecialUsersList);
    R_READONLY(TSet<TString>, RegistrationGeo);

public:
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& json) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& /*server*/) const override;
    virtual NAlerts::EDataFetcherType GetFetcherType() const override {
        return NAlerts::EDataFetcherType::EUserData;
    }
    virtual NAlerts::EAlertEntityType GetEntityType() const override {
        return NAlerts::EAlertEntityType::User;
    }
    virtual NAlerts::IServiceDataFetcher::TPtr BuildFetcher() const override;
    virtual TString GetSchemeDescription() const override {
        return "";
    }
private:
    static TFactory::TRegistrator<TUsersFetcherConfig> Registrator;
};


class TUsersFetcher : public NAlerts::IUserDataFetcher {
public:
    TUsersFetcher(const TUsersFetcherConfig& config)
        : IUserDataFetcher(config)
        , Config(config) {}

    virtual const TVector<TDriveUserData>& GetObjects() const override {
        return Users;
    }

protected:
    virtual bool DoFetch(const NAlerts::TFetcherContext& context) override;

private:
    R_READONLY(TUsersFetcherConfig, Config);
    mutable TVector<TDriveUserData> Users;
};
