#pragma once

#include "interfaces.h"

#include <drive/backend/alerts/condition.h>

#include <drive/backend/data/chargable.h>

#include <rtline/util/types/accessor.h>


class TSessionsFetcherConfig : public NAlerts::IServiceDataFetcherConfig {
private:
    R_READONLY(TSet<TString>, OffersFilter);
    R_READONLY(TTagsFilter, OfferTagsFilter);
    R_READONLY(TSet<TString>, StatesFilter);
    R_READONLY(TSet<TString>, ModelsFilter);
    R_OPTIONAL(TDuration, TagDuration);
    R_READONLY(NAlerts::EAlertEntityType, Entity, NAlerts::EAlertEntityType::User);

public:
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& json) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

    virtual TString GetSchemeDescription() const override;
    virtual NAlerts::EDataFetcherType GetFetcherType() const override;
    virtual NAlerts::EAlertEntityType GetEntityType() const override;
    virtual NAlerts::IServiceDataFetcher::TPtr BuildFetcher() const override;

    virtual TSet<NAlerts::EAlertEntityType> GetAcceptableEntityTypes() const override {
        return { NAlerts::EAlertEntityType::User, NAlerts::EAlertEntityType::Car, NAlerts::EAlertEntityType::Session };
    }

private:
    static NAlerts::EDataFetcherType GetType() {
        return NAlerts::EDataFetcherType::ESessions;
    }
    static TFactory::TRegistrator<TSessionsFetcherConfig> Registrator;
};

class TSessionsFetcher : public NAlerts::ISessionsDataFetcher {
public:
    using TSessionPtr = ::IEventsSession<TCarTagHistoryEvent>::TPtr;

    TSessionsFetcher(const TSessionsFetcherConfig& config)
        : ISessionsDataFetcher(config)
        , Config(config)
    {
    }

    virtual const TVector<TSessionPtr>& GetObjects() const override {
        return Sessions;
    }

protected:
    virtual bool DoFetch(const NAlerts::TFetcherContext& context) override;

private:
    R_READONLY(TSessionsFetcherConfig, Config);
    R_READONLY(TVector<TSessionPtr>, Sessions);
};
