#pragma once

#include <util/generic/ylimits.h>
#include <util/system/types.h>

namespace NAlerts {
    enum class EFetchedItems {
        Main /* "main" */,
        BillingTagSum /* "billing_sum" */,
        Location /* "location" */,
        Sensor /* "sensor" */,
        LandingAcceptanceDelta /* "landing_acceptance_time" */,
        LastActionDelta /* "last_action_time" */,
        RegApprovedDelta /* "approved_delta" */,
        SessionStateTime /* "time" */,
        SessionBill /* "billing_sum_price" */,
        ChatUnreadMessages /* "chat_unread_messages" */,
        ChatIsNew /* "chat_is_new" */,
        SessionsCount /* "sessions_count" */,
        IsPhoneVerified /* "is_phone_verified" */,
        TagsFilter /* "tags_filter" */,
        ChatLastMessageDelta /* "chat_last_message_delta" */,
        MaintenanceTime /* "maintenance_time" */,
        MaintenanceMileageDelta /* "maintenance_mileage_delta" */,
        LastRequestTime /* "last_request_time" */,
        BillingDebtAge /* "billing_debt_age" */,
        IsMailVerified /* "is_mail_verified" */,
        BindMailTime /* "bind_mail_time" */,
        CreditCardsCount /* "credit_cards_count" */,
        Lag /* "lag" */,
        TagField /* "tag_field" */,
        SpentSum /* "spent_sum" */,
        PackOfferRemainingDuration /* "offer_remaining_duration" */,
        PackOfferRemainingDistance /* "offer_remaining_distance" */,
        EventTagEventCount /* "event_tag_event_count" */,
        EventTagPresentEvents /* "event_tag_present_events" */,
        EventTagMetaCount /* "event_tag_meta_count" */,
        ScoringTag /* "scoring_tag" */,
        DictionaryTag /* "dictionary_tag" */,
        ActualSessionsCount /* "actual_sessions_count" */,
        TagFieldValue /* "tag_field_value" */,
        Evacuation /* "evacuation" */,
        FuelChange /* "fuel_change" */,
        BatteryDisconnect /* "battery_disconnect" */,
        SLADeadline /* "sla_deadline" */,
        LastHistoryRide /* "history_ride" */,
    };

    enum class EDataFetcherType {
        ETestFetcher /* "test" */,
        EObjectTags /* "object_tags" */,
        ECarTags /* "car_tags" */,
        EChatState /* "chat_state" */,
        ESessions  /* "sessions" */,
        EUserData /* "user_data" */,
        ETraceTags /* "trace_tags" */,
        ETraceTagsHistory /* "trace_tags_history" */,
        ESensorHistoryIds /* "sensor_history_ids" */,
    };

    enum class EAlertEntityType {
        Car /* "car" */,
        User /* "user" */,
        Session /* "session" */,
        Undefined /* "undefined" */,
    };

    using TFetchedValue = ui64;
    constexpr TFetchedValue InvalidData = Max<ui64>();
}
