import sys

if "run_import_hook" in sys.modules:
    from drive.backend.api.objects import Object, Offer, User, PropertyPatch, Bill, OfferState
else:
    from objects import Object, Offer, User, PropertyPatch, Bill, OfferState


class Session:
    def __init__(self, id=None, user=None, obj=None):
        self.id = id
        self.obj = obj
        self.user = user

        self.start = None
        self.finish = None
        self.is_finished = None
        self.is_engine_on = None

        self.free_time = None
        self.offer = None
        self.total_price = None
        self.session = None

        self.property_patch = None

    @classmethod
    def from_json(cls, j):
        car_json = j.get("car")
        car = Object.from_json(car_json) if car_json else None

        segment = j.get("segment", {})
        meta = segment.get("meta", {})
        id = meta.get("session_id", {})
        user = User.from_json(j.get("user"))

        result = cls(id, user, car)

        car_telematics = car_json.get("telematics", {}) if car_json else None
        if car_telematics:
            result.is_engine_on = car_telematics.get("is_engine_on", False)

        result.start = meta.get("start")
        result.finish = meta.get("finish")
        result.is_finished = meta.get("finished", True)
        result.session_id = meta.get("session_id")

        session = segment.get("session", {})
        result.current_performing = session.get("current_performing")
        summary = session.get("specials", {})
        result.is_cancelled = summary.get("is_cancelled", False)
        result.free_time = summary.get("free_time", 0)
        result.total_price = summary.get("total_price", 0)
        result.total_price_hr = summary.get("total_price_hr", "")
        result.futures_offer_tag_id = j.get("futures_offer_tag_id")
        futures_offer = j.get("futures_offer")
        if futures_offer:
            result.futures_offer = Offer.from_json(futures_offer)
        result.futures_offer_failed = j.get("futures_offer_failed")
        current_offer = summary.get("current_offer")
        if current_offer:
            result.offer = Offer.from_json(current_offer)
        current_offer_state = summary.get("current_offer_state")
        if current_offer_state:
            result.offer_state = OfferState.from_json(current_offer_state)
        bill = summary.get("bill")
        if bill:
            result.bill = bill
            result.bill_lines = [Bill.from_json(bill_line) for bill_line in bill]

        result.total_price = summary.get("total_price")
        result.total_duration = summary.get("total_duration")
        property_patches = j.get("property_patches")

        if property_patches:
            result.property_patch = [PropertyPatch.from_json(patch) for patch in property_patches]

        return result
