#pragma once

#include <drive/backend/tags/tags_filter.h>

#include <util/generic/set.h>
#include <util/generic/string.h>

namespace NDrive {
    using TAreaId = TString;
    using TAreaIds = TSet<TAreaId>;
    using TZoneId = TString;
    using TZoneIds = TSet<TZoneId>;

    using TLocationTag = TString;
    using TLocationTags = TSet<TString>;
    using TLocationAreaIds = TSet<TString>;
    using TLocationTagsArray = TVector<TString>;
    using TOptionalLocationTag = TMaybe<TLocationTag>;

    const TLocationTag DefaultAllowDropLocationTag = "allow_drop_car";
    const TLocationTags DefaultAllowDropLocationTags = {DefaultAllowDropLocationTag};
    const TTagsFilter DefaultAllowDropLocationTagsFilter = TTagsFilter(DefaultAllowDropLocationTags, false, true);

    const TLocationTag ExplicitServiceIsAvailableLocationTag = "explicit_service_availability";
    const TLocationTags ServiceIsAvailableLocationTags = {DefaultAllowDropLocationTag, ExplicitServiceIsAvailableLocationTag};
    const TTagsFilter ServiceIsAvailableLocationTagsFilter = TTagsFilter(ServiceIsAvailableLocationTags, false, true);

    const TLocationTag DefaultAllowRidingLocationTag = "allow_riding";
    const TLocationTags DefaultAllowRidingLocationTags = {DefaultAllowRidingLocationTag};
    const TTagsFilter DefaultAllowRidingLocationTagsFilter = TTagsFilter(DefaultAllowRidingLocationTags, false, true);
    const TLocationTags DefaultAllowParkingLocationTags = DefaultAllowRidingLocationTags;
    const TTagsFilter DefaultAllowParkingLocationTagsFilter = TTagsFilter(DefaultAllowRidingLocationTags, false, true);

    const TLocationTag DefaultDenyDropLocationTag = "deny_drop_car";
    const TLocationTags DefaultDenyDropLocationTags = { DefaultDenyDropLocationTag };
    const TTagsFilter DefaultDenyDropLocationTagsFilter = TTagsFilter(DefaultDenyDropLocationTags, false, true);

    const TLocationTag DefaultPoiLocationTag = "poi";
    const TLocationTags DefaultPoiLocationTags = { DefaultPoiLocationTag };

    const TLocationTag DefaultAllowForcedDropLocationTag = "force_allow_drop_car";
    const TLocationTags DefaultAllowForcedDropLocationTags = { DefaultAllowForcedDropLocationTag };
    const TTagsFilter DefaultAllowForcedDropLocationTagsFilter = TTagsFilter(DefaultAllowForcedDropLocationTags, false, true);

    const TLocationTag DefaultParkingZonesAllowParkingLocationTag = "force_allow_parking";
    const TLocationTag DefaultParkingZonesDenyParkingLocationTag = "force_deny_parking";
    const TLocationTag DefaultSignalIssuesLocationTag = "signal_issues";

    const TString AreaLocationTagSuffix = "_area";
    const TLocationTag GlobalAreaLocationTag = "global_area";
    const TLocationTag MskAreaLocationTag = "msc_area";
    const TLocationTag SpbAreaLocationTag = "spb_area";
    const TLocationTag KazanAreaLocationTag = "kazan_area";
    const TLocationTag SochiAreaLocationTag = "sochi_area";
}
