#pragma once

#include <drive/backend/auth/common/auth.h>
#include <drive/library/cpp/blackbox/info.h>

class TBlackboxAuthInfo
    : public IAuthInfo
    , protected NDrive::TBlackboxInfo
{
    bool Authorized = false;
    ui32 Code = 0;
    TString ErrorMessage;

public:
    TBlackboxAuthInfo() = default;
    TBlackboxAuthInfo(const TString& errorMessage, ui32 code)
        : Authorized(false)
        , Code(code)
        , ErrorMessage(errorMessage)
    {
    }
    TBlackboxAuthInfo(NDrive::TBlackboxInfo&& info)
        : TBlackboxInfo(std::move(info))
        , Authorized(true)
    {
    }

    virtual bool IsAvailable() const override {
        return Authorized;
    }

    virtual ui32 GetCode() const override {
        return Code;
    }

    virtual const TString& GetEmail() const override {
        return GetDefaultEmail();
    }

    virtual const TString& GetPhone() const override {
        return GetDefaultPhone();
    }

    virtual const TString& GetMessage() const override {
        return ErrorMessage;
    }

    virtual const TString& GetUid() const override {
        return GetPassportUid();
    }

    virtual const TString& GetUsername() const override {
        return GetLogin();
    }

    const TString& GetLogin() const {
        return Login;
    }

    const TString& GetPassportUid() const {
        return PassportUid;
    }

    bool GetIsPlusUser() const {
        return IsPlusUser;
    }

    bool GetIsYandexoid() const {
        return IsYandexoid;
    }

    bool GetIgnoreDeviceId() const {
        return IgnoreDeviceId;
    }

    const TString& GetDefaultEmail() const {
        return DefaultEmail;
    }

    const TVector<TString>& GetValidatedMails() const {
        return ValidatedMails;
    }

    const TString& GetDefaultPhone() const {
        return DefaultPhone;
    }

    const TString& GetDeviceId() const {
        return DeviceId;
    }

    const TString& GetTVMTicket() const {
        return TVMTicket;
    }

    const TString& GetDeviceName() const {
        return DeviceName;
    }

    const TVector<TString>& GetScopes() const {
        return Scopes;
    }

    const TString& GetName() const {
        return Name;
    }

    const TString& GetDefaultAvatar() const {
        return DefaultAvatar;
    }

    const TString& GetEnvironment() const override {
        return Environment;
    }

    virtual NJson::TJsonValue GetInfo() const override;
};
