#pragma once

#include <drive/backend/auth/common/auth.h>

#include <drive/backend/abstract/base.h>

#include <drive/library/cpp/blackbox/client.h>

#include <rtline/util/network/neh.h>

class TBlackbox2AuthConfig: public IAuthModuleConfig {
public:
    enum class EAuthMethod {
        Any     /* "any" */,
        Cookie  /* "cookie" */,
        OAuth   /* "oauth" */,
    };

public:
    TBlackbox2AuthConfig(const TString& name);
    ~TBlackbox2AuthConfig();

    TBlackbox2AuthConfig(const TBlackbox2AuthConfig& other) = delete;
    TBlackbox2AuthConfig(TBlackbox2AuthConfig&& other) = default;

    bool ShouldIgnoreDeviceId() const {
        return IgnoreDeviceId;
    }

    bool AskUserTicket() const {
        return EnableUserTickets;
    }

    virtual THolder<IAuthModule> ConstructAuthModule(const IServerBase* server) const override;

    virtual void Init(const TYandexConfig::Section* section) override;
    virtual void ToString(IOutputStream& os) const override;

private:
    R_FIELD(TString, AuthHeader, "Authorization");
    R_FIELD(TString, Url, "http://blackbox.yandex.net/blackbox");
    R_FIELD(TString, CookieHost, "yandex.ru");
    R_FIELD(TString, Environment);
    R_FIELD(TSet<TString>, AcceptedScopes);
    R_FIELD(TVector<TString>, RequiredScopes);
    R_FIELD(ui32, DestinationClientId, 222);
    R_FIELD(ui32, SelfClientId, 0);
    R_FIELD(EAuthMethod, AuthMethod, EAuthMethod::Any);
    R_FIELD(bool, IgnoreDeviceId, false);
    R_FIELD(bool, EnableUserTickets, false);

    mutable TAtomicSharedPtr<NDrive::TBlackboxClient> Client;
    TMutex ClientLock;

private:
    static TFactory::TRegistrator<TBlackbox2AuthConfig> Registrator;
};

class TBlackbox2AuthModule : public IAuthModule {
public:
    TBlackbox2AuthModule(const TBlackbox2AuthConfig& config, TAtomicSharedPtr<NDrive::TBlackboxClient> client);

    TAtomicSharedPtr<NDrive::TBlackboxClient> GetClient() const {
        return Client;
    }

    virtual IAuthInfo::TPtr RestoreAuthInfo(IReplyContext::TPtr requestContext) const override;

private:
    NThreading::TFuture<NDrive::TBlackboxClient::TResponsePtr> MakeOAuthRequest(TStringBuf authorization, TStringBuf userIp) const;
    NThreading::TFuture<NDrive::TBlackboxClient::TResponsePtr> MakeSessionIdRequest(TStringBuf sessionId, TStringBuf userIp) const;

private:
    const TBlackbox2AuthConfig& Config;
    const TAtomicSharedPtr<NDrive::TBlackboxClient> Client;
};
