#pragma once

#include "database.h"
#include <drive/backend/auth/common/auth.h>
#include <util/generic/maybe.h>

class TExternalAuthInfo : public IAuthInfo {
public:
    TExternalAuthInfo(TMaybe<TString> maybeAuthId, NJson::TJsonValue info);

    bool IsAvailable() const override;
    ui32 GetCode() const override;
    NJson::TJsonValue GetInfo() const override;
    const TString& GetUserId() const override;

private:
    TMaybe<TString> MaybeAuthId;
    NJson::TJsonValue Info;
};

class TExternalAuthConfig;

class TExternalAuthModule : public IAuthModule {
public:
    TExternalAuthModule(const IExternalAccessTokensManager* tokensManager, const TString& scope);

    IAuthInfo::TPtr RestoreAuthInfo(IReplyContext::TPtr requestContext) const override;

private:
    const IExternalAccessTokensManager* TokensManager;
    const TString Scope;
};

class TExternalAuthConfig : public IAuthModuleConfig {
public:
    TExternalAuthConfig(const TString& name)
        : IAuthModuleConfig(name)
    {
    }

    THolder<IAuthModule> ConstructAuthModule(const IServerBase* server) const override;
    void ToString(IOutputStream& os) const override;
    void Init(const TYandexConfig::Section* section) override;

private:
    TString Scope;

private:
    static TFactory::TRegistrator<TExternalAuthConfig> Registrator;
};
