#include "fake.h"

IAuthInfo::TPtr TFakeAuthModule::RestoreAuthInfo(IReplyContext::TPtr requestContext) const {
    TStringBuf userId = requestContext->GetRequestData().HeaderInOrEmpty("Authorization");
    if (!userId) {
        userId = requestContext->GetCgiParameters().Get("user_id");
    }
    if (userId.contains("Bearer")) {
        userId = {};
    }
    if (userId.contains("OAuth")) {
        userId = {};
    }
    bool isAuthIdUserId = true;
    if (Config) {
        if (!userId) {
            userId = Config->GetDefaultUserId();
        }
        isAuthIdUserId = Config->GetIsAuthIdUserId();
    }
    if (userId) {
        return MakeAtomicShared<TFakeAuthInfo>(TString{userId}, isAuthIdUserId);
    } else {
        return MakeAtomicShared<TFakeAuthInfo>("fake", isAuthIdUserId);
    }
}

TFakeAuthConfig::TFactory::TRegistrator<TFakeAuthConfig> TFakeAuthConfig::Registrator("fake");
