#pragma once

#include <drive/backend/auth/common/auth.h>
#include <drive/library/cpp/jwt/aws.h>

class TJwtAuthInfo: public IAuthInfo {
public:
    TJwtAuthInfo(const TString& error)
        : ErrorMessage(error)
    {
    }
    TJwtAuthInfo(NDrive::TAmazonCognitoIdToken&& token)
        : Token(std::move(token))
    {
    }

    bool IsAvailable() const override {
        return Token.Defined();
    }
    ui32 GetCode() const override {
        return Token ? 0 : HTTP_UNAUTHORIZED;
    }
    const TString& GetMessage() const override {
        return ErrorMessage;
    }
    const TString& GetEmail() const override {
        return Token ? Token->Email : Default<TString>();
    }
    const TString& GetPhone() const override {
        return Token ? Token->Phone : Default<TString>();
    }
    const TString& GetUid() const override {
        return Token ? Token->UserId : Default<TString>();
    }
    const TString& GetUsername() const override {
        return Token ? Token->Username : Default<TString>();
    }

    NJson::TJsonValue GetInfo() const override;

private:
    TMaybe<NDrive::TAmazonCognitoIdToken> Token;
    TString ErrorMessage;
};
