#pragma once

#include <drive/backend/auth/common/auth.h>

#include <drive/library/cpp/jwt/key.h>

class TJwtAuthConfig: public IAuthModuleConfig {
public:
    TJwtAuthConfig(const TString& name);

    const NDrive::TJwkDescriptions& GetKeys() const {
        return Keys;
    }

    THolder<IAuthModule> ConstructAuthModule(const IServerBase* server) const override;

    void Init(const TYandexConfig::Section* section) override;
    void ToString(IOutputStream& os) const override;

private:
    NDrive::TJwkDescriptions Keys;

private:
    static TFactory::TRegistrator<TJwtAuthConfig> Registrator;
};

class TJwtAuthModule: public IAuthModule {
public:
    TJwtAuthModule(const TJwtAuthConfig& config);

    IAuthInfo::TPtr RestoreAuthInfo(IReplyContext::TPtr requestContext) const override;

private:
    NDrive::TJwks Keys;
};
