#pragma once

#include <drive/backend/auth/common/auth.h>

class TExceptionAuthInfo: public IAuthInfo {
public:
    TExceptionAuthInfo(std::exception_ptr exception, TString&& message)
        : Exception(std::move(exception))
        , Message(std::move(message))
    {
    }

    const TString& GetMessage() const override {
        return Message;
    }
    bool IsAvailable() const override {
        return false;
    }

    NJson::TJsonValue GetInfo() const override;

private:
    std::exception_ptr Exception;
    TString Message;
};

class TMetaAuthInfo: public IAuthInfo {
public:
    using TInfos = TMap<TString, IAuthInfo::TPtr>;

public:
    TMetaAuthInfo(TInfos&& infos);

    virtual bool IsAvailable() const override;
    virtual const TString& GetUid() const override;
    virtual const TString& GetUsername() const override;
    virtual const TString& GetUserId() const override;

    virtual const TString& GetEmail() const override;
    virtual const TString& GetPhone() const override;

    virtual const TString& GetMessage() const override;
    virtual NJson::TJsonValue GetInfo() const override;
    virtual ui32 GetCode() const override;

private:
    TString GetMessageImpl() const;

private:
    TInfos Infos;
    TString Message;
};

class TMetaAuthModule: public IAuthModule {
public:
    using TSubmodules = TVector<std::pair<TString, IAuthModule::TPtr>>;

public:
    TMetaAuthModule(TSubmodules&& submodules)
        : Submodules(std::move(submodules))
    {
    }

    virtual IAuthInfo::TPtr RestoreAuthInfo(IReplyContext::TPtr requestContext) const override;

private:
    TSubmodules Submodules;
};

class TMetaAuthConfig: public IAuthModuleConfig {
public:
    using IAuthModuleConfig::IAuthModuleConfig;

    virtual THolder<IAuthModule> ConstructAuthModule(const IServerBase* server) const override;

    virtual void Init(const TYandexConfig::Section* section) override;
    virtual void ToString(IOutputStream& os) const override;

private:
    TVector<TString> Submodules;

private:
    static TFactory::TRegistrator<TMetaAuthConfig> Registrator;
};
