#pragma once

#include <drive/backend/auth/common/auth.h>

#include <rtline/util/network/neh.h>
#include <rtline/util/network/neh_request.h>
#include <rtline/util/types/accessor.h>

#include <drive/library/cpp/yang/config.h>
#include <drive/library/cpp/yang/client.h>

class TYangAuthInfo: public IAuthInfo {
private:
    const bool Available;
    const TString UserId;
    const TString WorkerId;

public:
    TYangAuthInfo(bool available, const TString& userId, const TString& workerId = "")
        : Available(available)
        , UserId(userId)
        , WorkerId(workerId)
    {
    }

    virtual bool IsAvailable() const override {
        return Available;
    }

    virtual const TString& GetUserId() const override {
        return UserId;
    }

    virtual const TString& GetWorkerId() const {
        return WorkerId;
    }
};

class TYangAuthConfig;

class TYangAuthModule: public IAuthModule {
public:
    TYangAuthModule(const TYangAuthConfig& config, TAtomicSharedPtr<TYangClient> yangClient);

    virtual IAuthInfo::TPtr RestoreAuthInfo(IReplyContext::TPtr requestContext) const override;

private:
    const TString DefaultUserId;
    const bool CheckIsActivePair;
    TAtomicSharedPtr<TYangClient> YangClient;
};

class TYangAuthConfig: public IAuthModuleConfig {
    R_READONLY(TYangClientConfig, ClientConfig);
    R_READONLY(bool, CheckIsActivePair, true);
    R_READONLY(TString, DefaultUserId, "yang-robot");

public:
    using IAuthModuleConfig::IAuthModuleConfig;

    virtual THolder<IAuthModule> ConstructAuthModule(const IServerBase* /*server*/) const override {
        if (!YangClient) {
            YangClient = MakeAtomicShared<TYangClient>(ClientConfig);
        }
        return MakeHolder<TYangAuthModule>(*this, YangClient);
    }

    virtual void Init(const TYandexConfig::Section* section) override;
    virtual void ToString(IOutputStream& os) const override;

private:
    static TFactory::TRegistrator<TYangAuthConfig> Registrator;
    mutable TAtomicSharedPtr<TYangClient> YangClient;
};
