#pragma once
#include <drive/backend/background/manager/regular.h>

#include <drive/backend/data/alerts/config.h>
#include <drive/backend/data/proto/alerts.pb.h>
#include <drive/backend/database/drive_api.h>

#include <rtline/library/async_proxy/async_delivery.h>
#include <rtline/util/network/neh.h>

class TAlertsChildSeatsConfig: public IBackgroundRegularProcessConfig {
private:
    TString NotifierName;
    TString ObservedTagName;

    TDuration RegularAbsentAlert = TDuration::Minutes(5);
    static TFactory::TRegistrator<TAlertsChildSeatsConfig> Registrator;

public:
    using IBackgroundRegularProcessConfig::IBackgroundRegularProcessConfig;

    const TString& GetNotifierName() const {
        return NotifierName;
    }

    const TString& GetObservedTagName() const {
        return ObservedTagName;
    }

    TDuration GetRegularAbsentAlert() const {
        return RegularAbsentAlert;
    }

    virtual IBackgroundProcess* Construct() const override;

    virtual void Init(const TYandexConfig::Section* section) override {
        IBackgroundRegularProcessConfig::Init(section);
        AssertCorrectConfig(section->GetDirectives().GetValue("NotifierName", NotifierName), "no 'NotifierName' field");

        RegularAbsentAlert = section->GetDirectives().Value("RegularAbsentAlert", RegularAbsentAlert);
        ObservedTagName = section->GetDirectives().Value("TagName", ObservedTagName);
    }

    virtual void ToString(IOutputStream& os) const override {
        IBackgroundRegularProcessConfig::ToString(os);
        os << "NotifierName: " << NotifierName << Endl;
        os << "RegularAbsentAlert: " << RegularAbsentAlert << Endl;
    }
};

class TAlertsChildSeats: public IBackgroundRegularProcessImpl<NDrive::IServer> {
private:
    using TBase = IBackgroundRegularProcessImpl<NDrive::IServer>;
    const TAlertsChildSeatsConfig* Config = nullptr;

protected:
    bool DoExecuteImpl(TBackgroundProcessesManager* /*manager*/, IBackgroundProcess::TPtr /*self*/, const NDrive::IServer* server) const override;

public:
    TAlertsChildSeats(const TAlertsChildSeatsConfig* config)
        : TBase(*config)
        , Config(config) {
    }

    virtual void Stop() override {
    }

    virtual void Start() override {
    }
};
