#pragma once
#include <drive/backend/background/manager/regular.h>

#include <drive/backend/database/drive_api.h>
#include <drive/backend/data/alerts/config.h>
#include <drive/backend/data/proto/alerts.pb.h>

#include <rtline/library/async_proxy/async_delivery.h>
#include <rtline/util/network/neh.h>

class TAlertsDevicesConfig: public IBackgroundRegularProcessConfig {
private:
    static TFactory::TRegistrator<TAlertsDevicesConfig> Registrator;

    R_READONLY(TString, NotifierName);
    R_READONLY(TDuration, RegularAbsentAlert, TDuration::Minutes(10));
    R_READONLY(bool, NoSignalNotificationEnabled, false);
    R_READONLY(TString, EvacuationTag);
public:

    using IBackgroundRegularProcessConfig::IBackgroundRegularProcessConfig;

    virtual IBackgroundProcess* Construct() const override;

    virtual void Init(const TYandexConfig::Section* section) override {
        IBackgroundRegularProcessConfig::Init(section);
        AssertCorrectConfig(section->GetDirectives().GetValue("NotifierName", NotifierName), "no 'NotifierName' field");

        RegularAbsentAlert = section->GetDirectives().Value("RegularAbsentAlert", RegularAbsentAlert);
        NoSignalNotificationEnabled = section->GetDirectives().Value("NoSignalNotificationEnabled", NoSignalNotificationEnabled);
        EvacuationTag = section->GetDirectives().Value("EvacuationTag", EvacuationTag);
    }

    virtual void ToString(IOutputStream& os) const override {
        IBackgroundRegularProcessConfig::ToString(os);
        os << "NotifierName: " << NotifierName << Endl;
        os << "RegularAbsentAlert: " << RegularAbsentAlert << Endl;
        os << "NoSignalNotificationEnabled: " << NoSignalNotificationEnabled << Endl;
        os << "EvacuationTag: " << EvacuationTag << Endl;
    }
};

class TAlertsDevices: public ISerializableProtoBackgroundProcess<NDrive::NProto::TDeviceAlertsState, IBackgroundRegularProcessImpl<NDrive::IServer>> {
private:
    using TBase = ISerializableProtoBackgroundProcess<NDrive::NProto::TDeviceAlertsState, IBackgroundRegularProcessImpl<NDrive::IServer>>;
    virtual void SerializeToProto(NDrive::NProto::TDeviceAlertsState& proto) const override;
    virtual bool DeserializeFromProto(const NDrive::NProto::TDeviceAlertsState& proto) override;

    const TAlertsDevicesConfig* Config = nullptr;
    mutable TMap<TString, TInstant> ProblemsSignal;
    mutable TMap<TString, TInstant> ProblemsVoltage;
    mutable TInstant TimestampLastCallNoTags = TInstant::Seconds(0);

protected:
    bool DoExecuteImpl(TBackgroundProcessesManager* /*manager*/, IBackgroundProcess::TPtr /*self*/, const NDrive::IServer* server) const override;

    bool FillProblemsReport(const NDrive::IServer* server, NDrive::INotifier::TPtr notifier) const;
public:
    TAlertsDevices(const TAlertsDevicesConfig* config)
        : TBase(*config)
        , Config(config) {
    }

    virtual void Stop() override {
    }

    virtual void Start() override {
    }

};
