#include "config.h"

#include "processor.h"

TBillingWatcherConfig::TFactory::TRegistrator<TBillingWatcherConfig> TBillingWatcherConfig::Registrator("billing_watcher");

IBackgroundProcess* TBillingWatcherConfig::Construct() const {
    return new TBillingWatcher(*this);
}

void TBillingWatcherConfig::Init(const TYandexConfig::Section* section) {
    IBackgroundRegularProcessConfig::Init(section);
    NotifierName = section->GetDirectives().Value("NotifierName", NotifierName);
    BillingQueue = section->GetDirectives().Value("BillingQueue", BillingQueue);
    TasksAtOnce = section->GetDirectives().Value("TasksAtOnce", TasksAtOnce);
    MaxIterations = section->GetDirectives().Value("MaxIterations", MaxIterations);
}

void TBillingWatcherConfig::ToString(IOutputStream& os) const {
    IBackgroundRegularProcessConfig::ToString(os);
    if (!!NotifierName) {
        os << "NotifierName: " << NotifierName << Endl;
    }
    os << "BillingQueue: " << BillingQueue << Endl;
    os << "TasksAtOnce: " << TasksAtOnce << Endl;
    os << "MaxIterations: " << MaxIterations << Endl;
}

TRefundWatcherConfig::TFactory::TRegistrator<TRefundWatcherConfig> TRefundWatcherConfig::Registrator("refund_watcher");

IBackgroundProcess* TRefundWatcherConfig::Construct() const {
    return new TRefundWatcher(*this);
}

void TRefundWatcherConfig::Init(const TYandexConfig::Section* section) {
    IBackgroundRegularProcessConfig::Init(section);
}

void TRefundWatcherConfig::ToString(IOutputStream& os) const {
    IBackgroundRegularProcessConfig::ToString(os);
}


TBillingQueueSwitcherConfig::TFactory::TRegistrator<TBillingQueueSwitcherConfig> TBillingQueueSwitcherConfig::Registrator("billing_queue_switcher");

IBackgroundProcess* TBillingQueueSwitcherConfig::Construct() const {
    return new TBillingQueueSwitcher(*this);
}

void TBillingQueueSwitcherConfig::Init(const TYandexConfig::Section* section) {
    IBackgroundRegularProcessConfig::Init(section);
    TasksAtOnce = section->GetDirectives().Value("TasksAtOnce", TasksAtOnce);
}

void TBillingQueueSwitcherConfig::ToString(IOutputStream& os) const {
    IBackgroundRegularProcessConfig::ToString(os);
    os << "TasksAtOnce: " << TasksAtOnce << Endl;
}
