#pragma once
#include <drive/backend/background/common/history.h>
#include <drive/backend/background/manager/regular.h>

#include <drive/backend/billing/interfaces/tasks.h>


class TBillingWatcherConfig: public IBackgroundRegularProcessConfig {
private:
    R_READONLY(TString, NotifierName);
    R_READONLY(EBillingQueue, BillingQueue, EBillingQueue::Active);
    R_READONLY(ui32, TasksAtOnce, 100);
    R_READONLY(ui32, MaxIterations, 100);
    static TFactory::TRegistrator<TBillingWatcherConfig> Registrator;

public:
    using IBackgroundRegularProcessConfig::IBackgroundRegularProcessConfig;

    virtual IBackgroundProcess* Construct() const override;

    virtual void Init(const TYandexConfig::Section* section) override;
    virtual void ToString(IOutputStream& os) const override;
};


class TRefundWatcherConfig: public IBackgroundRegularProcessConfig {
private:
    static TFactory::TRegistrator<TRefundWatcherConfig> Registrator;

public:
    using IBackgroundRegularProcessConfig::IBackgroundRegularProcessConfig;
    virtual IBackgroundProcess* Construct() const override;

    virtual void Init(const TYandexConfig::Section* section) override;
    virtual void ToString(IOutputStream& os) const override;
};

class TBillingQueueSwitcherConfig: public IBackgroundRegularProcessConfig {
private:
    R_READONLY(ui32, TasksAtOnce, 100);
    static TFactory::TRegistrator<TBillingQueueSwitcherConfig> Registrator;

public:
    using IBackgroundRegularProcessConfig::IBackgroundRegularProcessConfig;
    virtual IBackgroundProcess* Construct() const override;

    virtual void Init(const TYandexConfig::Section* section) override;
    virtual void ToString(IOutputStream& os) const override;
};
