#pragma once

#include <drive/backend/background/common/history.h>
#include <drive/backend/background/manager/regular.h>

#include <drive/backend/billing/manager.h>
#include <drive/backend/proto/background.pb.h>

class TBillingWatcherConfig;
class TRefundWatcherConfig;
class TBillingQueueSwitcherConfig;

class TBillingWatcher: public ISerializableProtoBackgroundProcess<NDrive::NProto::TEmptyProcessorData, IBackgroundRegularProcessImpl<NDrive::IServer>> {
private:
    using TBase = ISerializableProtoBackgroundProcess<NDrive::NProto::TEmptyProcessorData, IBackgroundRegularProcessImpl<NDrive::IServer>>;

    virtual void SerializeToProto(NDrive::NProto::TEmptyProcessorData& proto) const override;
    virtual bool DeserializeFromProto(const NDrive::NProto::TEmptyProcessorData& proto) override;

    const TBillingWatcherConfig& Config;

protected:
    bool DoExecuteImpl(TBackgroundProcessesManager* /*manager*/, IBackgroundProcess::TPtr /*self*/, const NDrive::IServer* server) const override;
public:
    TBillingWatcher(const TBillingWatcherConfig& config);

    virtual void Stop() override {
    }

    virtual void Start() override {
    }

};

class TRefundWatcher: public ISerializableProtoBackgroundProcess<NDrive::NProto::TEmptyProcessorData, IBackgroundRegularProcessImpl<NDrive::IServer>> {
private:
    using TBase = ISerializableProtoBackgroundProcess<NDrive::NProto::TEmptyProcessorData, IBackgroundRegularProcessImpl<NDrive::IServer>>;

    virtual void SerializeToProto(NDrive::NProto::TEmptyProcessorData& proto) const override;
    virtual bool DeserializeFromProto(const NDrive::NProto::TEmptyProcessorData& proto) override;

    const TRefundWatcherConfig& Config;
protected:
    bool DoExecuteImpl(TBackgroundProcessesManager* /*manager*/, IBackgroundProcess::TPtr /*self*/, const NDrive::IServer* server) const override;
public:
    TRefundWatcher(const TRefundWatcherConfig& config);

    virtual void Stop() override {
    }

    virtual void Start() override {
    }
};

class TBillingQueueSwitcher: public ISerializableProtoBackgroundProcess<NDrive::NProto::TEmptyProcessorData, IBackgroundRegularProcessImpl<NDrive::IServer>> {
private:
    using TBase = ISerializableProtoBackgroundProcess<NDrive::NProto::TEmptyProcessorData, IBackgroundRegularProcessImpl<NDrive::IServer>>;

    virtual void SerializeToProto(NDrive::NProto::TEmptyProcessorData& proto) const override;
    virtual bool DeserializeFromProto(const NDrive::NProto::TEmptyProcessorData& proto) override;

    const TBillingQueueSwitcherConfig& Config;

protected:
    bool DoExecuteImpl(TBackgroundProcessesManager* /*manager*/, IBackgroundProcess::TPtr /*self*/, const NDrive::IServer* server) const override;

public:
    enum class EQueueField {
        Queue /* "queue" */,
        NextQueue /* "next_queue" */
    };

    TBillingQueueSwitcher(const TBillingQueueSwitcherConfig& config);

    TSet<EBillingQueue> GetQueues(const NDrive::IServer* server, const TString& settingName) const;
    void SoftSwitchQueue(const TBillingManager& billingManager, const TSet<EBillingQueue>& queues, const TString& userId, const ui32 tasksAtOnce, const ui32 minPriority) const;
    void HardSwitchQueue(const TBillingManager& billingManager, const TSet<EBillingQueue>& queues, const TString& userId, const ui32 tasksAtOnce, const ui32 minPriority) const;

    virtual void Stop() override;
    virtual void Start() override;
};
