#pragma once
#include <drive/backend/background/manager/regular.h>
#include <drive/backend/background/telegram_bot/telegram.h>

#include <util/string/join.h>

class TCaller {
public:
    R_FIELD(TString, Name);
    R_FIELD(TString, Phone);

public:
    TCaller()
    {
    }

    TCaller(const TString& phone, const TString& name)
        : Name(name)
        , Phone(phone)
    {
    }
};

class TCallerTelegramBotProcessorConfig: public ITelegramCommandsProcessorConfig {
private:
    TString StorageName;
    TString CallerUrlTmpl = TString("http://cipt-helper3.yndx.net:8089/cgi-bin/waycall.cgi?caller={{caller}}&callername={{caller_name}}&calling={{calling}}");
    TVector<TCaller> Callers;
    TCaller DefaultCaller;

public:
    static TFactory::TRegistrator<TCallerTelegramBotProcessorConfig> Registrator;

    virtual void ToString(IOutputStream& os) const override {
        os << "StorageName: " << StorageName << Endl;
        os << "CallerUrlTmpl: " << CallerUrlTmpl << Endl;
        os << "<Callers>" << Endl;
        for (auto&& caller : Callers) {
            os << caller.GetPhone() << ": " << caller.GetName() << Endl;
        }
        os << "</Callers>" << Endl;
        os << "DefaultCaller:" << DefaultCaller.GetPhone() << Endl;
        os << "DefaultCallerName: " << DefaultCaller.GetName() << Endl;
    }

    virtual void Init(TYandexConfig::Section* section) override {
        AssertCorrectConfig(section->GetDirectives().GetValue("StorageName", StorageName), "no 'StorageName' field");
        CallerUrlTmpl = section->GetDirectives().Value("CallerUrlTmpl", CallerUrlTmpl);

        auto children = section->GetAllChildren();
        auto sectionIt = children.find("Callers");
        if (sectionIt != children.end()) {
            for (auto&& callerIt : sectionIt->second->GetDirectives()) {
                Callers.emplace_back(callerIt.first, callerIt.second);
                DEBUG_LOG << "Add caller: " << Callers.back().GetPhone() << " " << Callers.back().GetName() << Endl;
            }
        }

        AssertCorrectConfig(section->GetDirectives().contains("DefaultCaller"), "no 'DefaultCaller' field");
        DefaultCaller = TCaller(section->GetDirectives().Value("DefaultCaller", TString()), section->GetDirectives().Value("DefaultCallerName", TString()));
    }

    const TString& GetStorageName() const {
        return StorageName;
    }

    const TString& GetCallerUrlTmpl() const {
        return CallerUrlTmpl;
    }

    const TVector<TCaller>& GetCallers() const {
        return Callers;
    }

    const TCaller& GetDefaultCaller() const {
        return DefaultCaller;
    }

    ITelegramCommandsProcessor* Construct(TActiveTelegramBot* bot) const override;
};

