#include "config.h"

#include "processor.h"

#include <rtline/util/algorithm/container.h>

#include <util/string/join.h>

TCarMarkersConfig::TFactory::TRegistrator<TCarMarkersConfig> TCarMarkersConfig::Registrator("car_markers");

IBackgroundProcess* TCarMarkersConfig::Construct() const {
    return new TCarMarkers(this);
}

void TCarMarkersConfig::Init(const TYandexConfig::Section* section) {
    IBackgroundRegularCarsProcessConfig::Init(section);
    NotifierName = section->GetDirectives().Value("NotifierName", NotifierName);
    FullTankTagName = section->GetDirectives().Value("FullTankTagName", FullTankTagName);
    AssertCorrectConfig(!!FullTankTagName, "Incorrect FullTankTagName field in configuration");
    SensorFreshness = section->GetDirectives().Value("SensorFreshness", SensorFreshness);
    FuelLevel = section->GetDirectives().Value("FuelLevel", FuelLevel);
    AssertCorrectConfig(FuelLevel <= 100 && FuelLevel >= 0, "Incorrect FuelLevel field in configuration");
    TVector<TString> tags;
    section->GetDirectives().FillArray("RidingTagsCorrection", tags);
    RidingTagsCorrection = MakeSet(tags);
    PackOfferPushNotifier = section->GetDirectives().Value("PackOfferPushNotifier", PackOfferPushNotifier);
}

void TCarMarkersConfig::ToString(IOutputStream& os) const {
    IBackgroundRegularCarsProcessConfig::ToString(os);
    os << "NotifierName: " << NotifierName << Endl;
    os << "FullTankTagName: " << FullTankTagName << Endl;
    os << "SensorFreshness: " << SensorFreshness << Endl;
    os << "FuelLevel: " << FuelLevel << Endl;
    os << "RidingTagsCorrection: " << JoinSeq(", ", RidingTagsCorrection) << Endl;
    os << "PackOfferPushNotifier: " << PackOfferPushNotifier << Endl;
}
