#pragma once
#include <drive/backend/background/common/common.h>
#include <drive/backend/background/manager/regular.h>

#include <rtline/library/time_restriction/time_restriction.h>
#include <rtline/util/types/accessor.h>

class TCarMarkersConfig: public IBackgroundRegularCarsProcessConfig {
private:
    static TFactory::TRegistrator<TCarMarkersConfig> Registrator;
    R_READONLY(TString, NotifierName);
    R_READONLY(TString, FullTankTagName);
    R_READONLY(ui32, FuelLevel, 90);
    R_READONLY(TDuration, SensorFreshness, TDuration::Max());
    R_READONLY(double, SensorPrecision, 2);
    R_READONLY(TSet<TString>, RidingTagsCorrection);
    R_FIELD(TString, PackOfferPushNotifier);
    R_FIELD(TString, PackOfferDistanceThresholdPushTemplate, "pack_offer_distance_threshold_push_template");
    R_FIELD(TString, PackOfferDurationThresholdPushTemplate, "pack_offer_duration_threshold_push_template");

public:
    using IBackgroundRegularCarsProcessConfig::IBackgroundRegularCarsProcessConfig;

    virtual IBackgroundProcess* Construct() const override;

    virtual void Init(const TYandexConfig::Section* section) override;

    virtual void ToString(IOutputStream& os) const override;
};
